/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.lakeformation.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.lakeformation.model.TableResource;

@SdkInternalApi
public class TableResourceMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> TABLEWILDCARD_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableWildcard").build();
    private static final TableResourceMarshaller instance = new TableResourceMarshaller();

    public static TableResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableResource tableResource, ProtocolMarshaller protocolMarshaller) {
        if (tableResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tableResource.getCatalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall(tableResource.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(tableResource.getName(), NAME_BINDING);
            protocolMarshaller.marshall(tableResource.getTableWildcard(), TABLEWILDCARD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

