/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.classes.Dictionary.ClassDefinition;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.jalapeno.tools.objects.RefactoringTask;
import com.jalapeno.tools.objects.refactoring.ExtractSuperclass;
import org.apache.tools.ant.BuildException;

public class ExtractSuperclassTask
extends RefactoringTask {
    private String mSuperclass;
    private boolean mPullinterfaces = true;

    public String getSuperclass() {
        return this.mSuperclass;
    }

    public void setSuperclass(String string) {
        this.mSuperclass = string;
    }

    public boolean isPullinterfaces() {
        return this.mPullinterfaces;
    }

    public void setPullinterfaces(boolean bl) {
        this.mPullinterfaces = bl;
    }

    @Override
    protected void checkAttributes() throws BuildException {
        super.checkAttributes();
        if (this.mSuperclass == null) {
            throw new BuildException("Missing required attribute: superclass");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        ExtractSuperclass extractSuperclass;
        Database database = this.getDatabase();
        try {
            extractSuperclass = new ExtractSuperclass(database, this.mClassName, this.mSuperclass, this.mPullinterfaces);
            extractSuperclass.doPhase1();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException("Failed to extract superclass " + this.getSuperclass() + " from class " + this.mClassName, (Throwable)exception);
        }
        try {
            database.transactionStart();
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Error starting transaction: " + cacheException.getMessage(), (Throwable)cacheException);
        }
        try {
            String string = extractSuperclass.doPhase2();
            database.utilities().compileCacheClass(string, "+db");
        }
        catch (Throwable throwable) {
            try {
                ClassDefinition.delete(database, new Id(this.mSuperclass));
            }
            catch (Throwable throwable2) {
                throwable.printStackTrace();
            }
            finally {
                try {
                    database.transactionRollback();
                }
                catch (CacheException cacheException) {
                    cacheException.printFullTrace(System.err);
                    throw new BuildException("Error rolling back transaction: " + cacheException.getMessage(), (Throwable)cacheException);
                }
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof CacheException) {
                ((CacheException)throwable).printFullTrace(System.err);
                throw new BuildException("Failed to extract superclass " + this.getSuperclass() + " from class " + this.mClassName, throwable);
            }
            throw new BuildException(throwable);
        }
        try {
            database.transactionCommit();
        }
        catch (CacheException cacheException) {
            cacheException.printFullTrace(System.err);
            throw new BuildException("Error committing transaction: " + cacheException.getMessage(), (Throwable)cacheException);
        }
    }

    @Override
    protected String execute(Database database) {
        throw new UnsupportedOperationException("Method execute() is not implemented in class com.jalapeno.tools.objects.ExtractSuperclassTask");
    }
}

