/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.CacheException;
import com.jalapeno.tools.objects.DefaultConfigurator;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.Persister;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DefaultConfiguratorForPath
extends DefaultConfigurator {
    private String mPath;
    private String mClasspathDir;
    private String mPrefix = "";
    private ClassLoader mLoader;
    private Java2DBMapping mProvider;
    private URL[] mClasspath;
    private String[] mClassNames;

    protected DefaultConfiguratorForPath(String string, String string2) {
        this.mPath = string;
        this.mClasspathDir = string2;
        this.mClassNames = null;
    }

    protected DefaultConfiguratorForPath(URL[] uRLArray, String[] stringArray) {
        this.mClassNames = stringArray;
        this.mClasspath = uRLArray;
    }

    public static DefaultConfiguratorForPath getInstance(String string, String string2) {
        return new DefaultConfiguratorForPath(string, string2);
    }

    public static DefaultConfiguratorForPath getInstance(URL[] uRLArray, String[] stringArray) {
        return new DefaultConfiguratorForPath(uRLArray, stringArray);
    }

    public void useAnnotationsBasedTransientFilter() throws CacheException {
        this.mProvider = Persister.createAnnotationsProvider();
    }

    public void useXMLDescriptorBasedTransientFilter() throws CacheException {
        this.mProvider = Persister.createHibernateProvider();
    }

    public void setTransientFilter(Java2DBMapping java2DBMapping) {
        this.mProvider = java2DBMapping;
    }

    protected void setTransientFilterIfUnset(Java2DBMapping java2DBMapping) {
        if (this.mProvider != null) {
            return;
        }
        this.mProvider = java2DBMapping;
    }

    @Override
    public Collection getJavaClassesToPersist() throws ClassNotFoundException {
        if (this.mClassNames != null) {
            this.createClassLoader();
            ArrayList<Class> arrayList = new ArrayList<Class>(this.mClassNames.length);
            for (int i = 0; i < this.mClassNames.length; ++i) {
                Class clazz = this.classForName(this.mClassNames[i]);
                if (clazz == null) continue;
                arrayList.add(clazz);
            }
            return arrayList;
        }
        try {
            this.initClassLoader();
            return this.findAllClasses();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Problems reading " + this.mPath + ". Caused by: " + iOException.getMessage());
        }
    }

    private List findAllClasses() throws IOException, ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        String string = File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(this.mPath, string);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2;
            String string3 = string2 = stringTokenizer.nextToken();
            if (this.mClasspathDir != null && this.mClasspathDir.length() != 0 && !((File)(object = new File(string2))).isAbsolute()) {
                string3 = new File(this.mClasspathDir, string2).toString();
            }
            if (string2.toLowerCase().endsWith(".jar")) {
                arrayList.addAll(this.findAllClassesInZip(new JarFile(string3)));
                continue;
            }
            if (string2.toLowerCase().endsWith(".zip")) {
                arrayList.addAll(this.findAllClassesInZip(new ZipFile(string3)));
                continue;
            }
            if (string2.toLowerCase().endsWith(".class")) {
                object = this.mClasspathDir != null ? DefaultConfiguratorForPath.relativeFileName(string2, this.mClasspathDir) : string2;
                Class clazz = this.classForFile((String)object);
                if (clazz == null) continue;
                arrayList.add(clazz);
                continue;
            }
            if (new File(string3).isDirectory()) {
                arrayList.addAll(this.listAllClassesInDir(string2));
                continue;
            }
            if (this.isValidClassName(string2)) {
                arrayList.add(Class.forName(string2, true, this.getLoader()));
                continue;
            }
            throw new IllegalArgumentException("Unrecognized element: " + string2);
        }
        return arrayList;
    }

    private static String relativeFileName(String string, String string2) throws IOException {
        File file = new File(string2).getCanonicalFile();
        File file2 = new File(string).getCanonicalFile();
        String string3 = file2.getName();
        for (file2 = file2.getParentFile(); file2 != null && !file.equals(file2); file2 = file2.getParentFile()) {
            string3 = file2.getName() + File.separator + string3;
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Directory " + string2 + " is not parent directory for " + string);
        }
        return string3;
    }

    private boolean isValidClassName(String string) {
        try {
            Class.forName(string, false, this.getLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private List findAllClassesInZip(ZipFile zipFile) throws ClassNotFoundException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            Class clazz = this.classForFile(string = new File(string).getPath());
            if (clazz == null) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private List listAllClassesInDir(String string) throws ClassNotFoundException {
        this.constructPrefix(new File(this.mPath));
        File file = new File(string);
        if (this.mClasspathDir != null && this.mClasspathDir.length() != 0 && !file.isAbsolute()) {
            file = new File(this.mClasspathDir, string);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Path " + file + " is neither a valid jar file," + " nor zip file," + " nor a directory");
        }
        ArrayList arrayList = new ArrayList();
        this.listAllClassesInDir(file, arrayList, this.mPrefix);
        return arrayList;
    }

    private void constructPrefix(File file) {
        this.mPrefix = "";
        if (this.mClasspathDir == null || this.mClasspathDir.length() == 0) {
            return;
        }
        File file2 = new File(this.mClasspathDir);
        File file3 = file;
        while (!file2.equals(file3)) {
            File file4 = file3.getParentFile();
            if (file4 == null) {
                throw new IllegalArgumentException("Root " + this.mClasspathDir + " is not a root directory for path " + file);
            }
            this.mPrefix = file3.getName() + "." + this.mPrefix;
            file3 = file4;
        }
    }

    private void listAllClassesInDir(File file, List list, String string) throws ClassNotFoundException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Class clazz;
            File file2 = fileArray[i];
            String string2 = string + file2.getName();
            if (file2.isDirectory()) {
                this.listAllClassesInDir(file2, list, string2 + ".");
            }
            if ((clazz = this.classForFile(string2)) == null) continue;
            list.add(clazz);
        }
    }

    private Class classForFile(String string) throws ClassNotFoundException {
        if (!string.toLowerCase().endsWith(".class")) {
            return null;
        }
        int n = string.lastIndexOf(".class");
        String string2 = string.substring(0, n);
        String string3 = "\\" + File.separator;
        string2 = string2.replaceAll(string3, ".");
        return this.classForName(string2);
    }

    private Class classForName(String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string, true, this.mLoader);
        if (this.mProvider != null && this.mProvider.isClassTransient(clazz)) {
            return null;
        }
        return clazz;
    }

    private void initClassLoader() throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.mClasspathDir != null && this.mClasspathDir.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.mClasspathDir, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                URL uRL = new File(string).toURL();
                arrayList.add(uRL);
            }
        }
        this.mClasspath = new URL[arrayList.size()];
        this.mClasspath = arrayList.toArray(this.mClasspath);
        this.createClassLoader();
    }

    private void createClassLoader() {
        this.mLoader = new URLClassLoader(this.mClasspath, this.getClass().getClassLoader());
    }

    public static void main(String[] stringArray) throws Exception {
        DefaultConfiguratorForPath defaultConfiguratorForPath = stringArray.length > 1 ? DefaultConfiguratorForPath.getInstance(stringArray[0], stringArray[1]) : DefaultConfiguratorForPath.getInstance(stringArray[0], null);
        Collection collection = defaultConfiguratorForPath.getJavaClassesToPersist();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    @Override
    public ClassLoader getLoader() {
        return this.mLoader;
    }
}

