/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.jalapeno.ApplicationContext;
import com.jalapeno.ObjectManager;
import com.jalapeno.tools.objects.ant.ClassesDataType;
import com.jalapeno.tools.objects.ant.Connection;
import com.jalapeno.tools.objects.ant.NamedEntity;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public abstract class ClassIterationTask
extends Task {
    private Connection mConnection;
    protected ClassesDataType mClasses;

    public Path getClasspath() {
        return this.mClasses.getClasspath();
    }

    public ArrayList getClasses() {
        return this.mClasses.getClasses();
    }

    public void execute() throws BuildException {
        if (this.mClasses == null) {
            throw new BuildException("fatal error no classes element");
        }
        String string = "jdbc:Cache://" + this.mConnection.getHost() + ":" + this.mConnection.getPort() + "/" + this.mConnection.getNamespace();
        try {
            ClassLoader classLoader;
            ObjectManager objectManager = ApplicationContext.createObjectManager(string, this.mConnection.getUser(), this.mConnection.getPassword(), "full");
            if (this.mClasses.getClasspath() != null) {
                String[] stringArray = this.mClasses.getClasspath().list();
                Object object = new URL[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    object[i] = new File((String)stringArray[i]).toURL();
                }
                classLoader = new URLClassLoader((URL[])object);
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (this.mClasses.getClasses() != null) {
                for (Object object : this.mClasses.getClasses()) {
                    String string2 = ((NamedEntity)object).getName();
                    Class<?> clazz = Class.forName(string2, false, classLoader);
                    this.performOneAction(objectManager, clazz, object);
                }
                this.postAction(objectManager);
            } else {
                System.out.println("In " + ((Object)((Object)this)).getClass().toString() + " no classes to process");
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    protected abstract void performOneAction(ObjectManager var1, Class var2, Object var3) throws Exception;

    protected void postAction(ObjectManager objectManager) throws Exception {
    }

    public void addConnection(Connection connection) {
        this.mConnection = connection;
    }

    public void addConfiguredClasses(ClassesDataType classesDataType) {
        this.mClasses = classesDataType;
    }
}

