/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime.dynamic;

import com.intersys.classes.CacheRootObject;
import com.intersys.objects.CacheException;
import com.jalapeno.ObjectManagerFactory;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.dynamic.ReconnectableProxy;
import com.jalapeno.runtime.dynamic.Shadow;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class Proxy {
    private CacheRootObject mStaticProxy;
    private boolean mLoaded;

    protected Proxy(CacheRootObject cacheRootObject) {
        this.mStaticProxy = cacheRootObject;
        this.mLoaded = false;
    }

    public static Object createDynamicProxy(CacheRootObject cacheRootObject, Class clazz, ObjectManagerFactory objectManagerFactory) throws IllegalAccessException, InstantiationException, CacheException {
        Proxy proxy = objectManagerFactory != null && objectManagerFactory.isOpen() ? new ReconnectableProxy(cacheRootObject, objectManagerFactory) : new Proxy(cacheRootObject);
        Object t = clazz.newInstance();
        Factory factory = (Factory)t;
        factory.setCallback(0, (Callback)proxy.getInterceptor());
        return t;
    }

    public static boolean isProxy(Object object) {
        return Enhancer.isEnhanced(object.getClass()) && object instanceof Shadow;
    }

    private MethodInterceptor getInterceptor() {
        return new Interceptor();
    }

    protected boolean handleDatabaseClosed(Object object) throws Exception {
        return false;
    }

    protected void replaceStaticProxy(CacheRootObject cacheRootObject) {
        this.mStaticProxy = cacheRootObject;
    }

    protected synchronized void load(Object object) throws Exception {
        this.mLoaded = true;
        try {
            this.mStaticProxy.swizzleDefault(object);
        }
        catch (Exception exception) {
            this.mLoaded = false;
            throw exception;
        }
    }

    private Object realObject() throws Exception {
        return this.mStaticProxy.detach(false);
    }

    private void swizzle(Object object) throws Exception {
        this.mStaticProxy.swizzleOneLevel(object);
    }

    protected boolean isLoaded() {
        return this.mLoaded;
    }

    private static boolean alwaysDispatchToSuper(Method method, int n) {
        String string;
        if (n == 0) {
            String string2 = method.getName();
            if ("hashCode".equals(string2)) {
                return true;
            }
            if ("finalize".equals(string2)) {
                return true;
            }
            if ("toString".equals(string2)) {
                return true;
            }
        } else if (n == 1 && "equals".equals(string = method.getName())) {
            return true;
        }
        return false;
    }

    static {
        ObjectFactory.dynamicProxyFactoryInitialized = true;
    }

    private class Interceptor
    implements MethodInterceptor {
        private Interceptor() {
        }

        public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
            if (objectArray.length == 0) {
                String string = method.getName();
                if ("isLoaded".equals(string)) {
                    return new Boolean(Proxy.this.mLoaded);
                }
                if ("writeReplace".equals(string)) {
                    return Proxy.this.realObject();
                }
                if ("swizzle".equals(string)) {
                    Proxy.this.swizzle(object);
                    return null;
                }
                if ("unswizzle".equals(string)) {
                    Proxy.this.mLoaded = false;
                    Proxy.this.mStaticProxy.getProxy().setStateReadDirty();
                    return null;
                }
                if ("shadowObject_fetchData".equals(string)) {
                    if (!Proxy.this.mLoaded) {
                        Proxy.this.load(object);
                    }
                    return null;
                }
            }
            if (Proxy.this.mLoaded) {
                return methodProxy.invokeSuper(object, objectArray);
            }
            if (Proxy.alwaysDispatchToSuper(method, objectArray.length)) {
                return methodProxy.invokeSuper(object, objectArray);
            }
            if (!Proxy.this.mStaticProxy.getDatabase().isOpen() && !Proxy.this.handleDatabaseClosed(object)) {
                throw new IllegalStateException("Can not fetch data on shadow object when connection to database is closed.");
            }
            if (Proxy.this.mStaticProxy.isClosed() && !Proxy.this.handleDatabaseClosed(object)) {
                throw new IllegalStateException("Object is detached from the database. Can not fetch data on it.");
            }
            if (!Proxy.this.mLoaded) {
                Proxy.this.load(object);
            }
            return methodProxy.invokeSuper(object, objectArray);
        }
    }
}

