/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.classes.CacheRootObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectFactory;
import java.util.Iterator;
import java.util.Map;

public class ObjectCopierUtil {
    protected DetachedObjectsManager mManager;
    protected ClassLoader mLoader;
    protected Map mTraversedObjects;

    public ObjectCopierUtil(DetachedObjectsManager detachedObjectsManager, ClassLoader classLoader, Map map) {
        this.mLoader = classLoader;
        if (this.mLoader == null) {
            this.mLoader = Thread.currentThread().getContextClassLoader();
        }
        this.mManager = detachedObjectsManager;
        this.mTraversedObjects = map;
    }

    public void reset() {
        this.mTraversedObjects.clear();
    }

    public Iterator getTraversedEntries() {
        return this.mTraversedObjects.entrySet().iterator();
    }

    protected CacheClass cacheClassFor(Object object) throws CacheException {
        try {
            return this.mManager.findImplementation(object.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Logger.debugOn()) {
                classNotFoundException.printStackTrace(Logger.out);
            }
            throw new CacheException(classNotFoundException, "Can not find Cache class corresponding to Java class " + object.getClass().getName());
        }
    }

    protected static boolean isFieldTransient(CacheField cacheField, boolean bl) {
        return !bl && cacheField.isCalculated() || cacheField.isTransient() && !cacheField.isCollection();
    }

    protected static CacheClass getCacheClass(CacheRootObject cacheRootObject) throws CacheException {
        return cacheRootObject.getProxy().getCacheClass();
    }

    protected JalapenoHelperInterface getHelper(CacheRootObject cacheRootObject) throws Exception {
        return this.factory().getHelper(ObjectCopierUtil.getCacheClass(cacheRootObject), this.mLoader);
    }

    protected ObjectFactory factory() {
        return this.mManager.getObjectFactory();
    }
}

