/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.classes.CacheRootObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.XML.Reader;
import com.intersys.classes.XML.Writer;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectHandleHolder;
import com.intersys.objects.StatusCodeHolder;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.Utilities;
import com.jalapeno.runtime.CacheObjectManager;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class CachePOJOUtilities
implements Utilities {
    private CacheObjectManager mManager;

    public CachePOJOUtilities(CacheObjectManager cacheObjectManager) {
        this.mManager = cacheObjectManager;
    }

    @Override
    public String serializeToXML(Object object) throws Exception {
        return this.serializeToXML(object, null, null, null);
    }

    @Override
    public String serializeToXML(Object object, String string, String string2) throws Exception {
        return this.serializeToXML(object, string, string2, null);
    }

    @Override
    public String serializeToXML(Object object, String string, String string2, String string3) throws Exception {
        Persistent persistent = this.getRunnableObject(object);
        Writer writer = new Writer(this.getFullDatabase());
        if (string != null) {
            writer.setCharset(string);
        }
        if (string2 != null) {
            writer.setDefaultNamespace(string2);
        }
        writer.setNoXMLDeclaration(Boolean.TRUE);
        writer.OutputToString();
        writer.RootObject(persistent, null, null, string3, null);
        String string4 = writer.GetXMLString(new StatusCodeHolder(null));
        if (this.amIUseLightConnection()) {
            persistent.release();
        }
        writer.release();
        return string4;
    }

    @Override
    public Object startXMLDocument(String string, String string2, String string3) throws Exception {
        Writer writer = new Writer(this.getFullDatabase());
        if (string2 != null) {
            writer.setCharset(string2);
        }
        if (string3 != null) {
            writer.setDefaultNamespace(string3);
        }
        writer.OutputToString();
        writer.StartDocument();
        writer.RootElement(string, null);
        return writer;
    }

    @Override
    public void addToXMLDocument(Object object, Object object2) throws Exception {
        if (!(object instanceof Writer)) {
            throw new IllegalArgumentException("XML Document was not created by this ObjectManager.  It must be cxreated by startXMLDocument method.");
        }
        Writer writer = (Writer)object;
        Persistent persistent = this.getRunnableObject(object2);
        writer.Object(persistent, null, null, null);
        if (this.amIUseLightConnection()) {
            persistent.release();
        }
    }

    @Override
    public String closeXMLDocument(Object object) throws Exception {
        if (!(object instanceof Writer)) {
            throw new IllegalArgumentException("XML Document was not created by this ObjectManager.  It must be cxreated by startXMLDocument method.");
        }
        Writer writer = (Writer)object;
        writer.EndRootElement();
        writer.EndDocument();
        String string = writer.GetXMLString(new StatusCodeHolder(null));
        writer.release();
        return string;
    }

    @Override
    public Object readFromXML(Class clazz, String string) throws Exception {
        this.mManager.startImplicitTransaction();
        try {
            Object object = this.doReadFromXML(clazz, string);
            if (object == null) {
                throw new IllegalArgumentException("Given string contains no instances fo class " + clazz.getName());
            }
            if (this.mManager.isInImplicitTransaction()) {
                this.mManager.commit();
            }
            return object;
        }
        catch (Exception exception) {
            if (this.mManager.isInImplicitTransaction()) {
                try {
                    this.mManager.rollback();
                }
                catch (Exception exception2) {
                    System.err.println("Transaction rollback failed.");
                    System.err.println("Rollback cause:");
                    exception.printStackTrace(System.err);
                    throw exception2;
                }
            }
            throw exception;
        }
    }

    private Object doReadFromXML(Class clazz, String string) throws Exception {
        CacheClass cacheClass = this.findImplementation(clazz);
        Reader reader = new Reader(this.getFullDatabase());
        String string2 = cacheClass.getName();
        int n = string2.lastIndexOf(46);
        String string3 = n < 0 ? string2 : string2.substring(n + 1);
        reader.OpenString(string, null);
        reader.Correlate(string3, string2);
        String[] stringArray = this.findSubClasses(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            n = string2.lastIndexOf(46);
            string3 = n < 0 ? string2 : string2.substring(n + 1);
            reader.Correlate(string3, string2);
        }
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        int n2 = 0;
        Object object = null;
        StatusCodeHolder statusCodeHolder = new StatusCodeHolder(null);
        while (true) {
            Object object2;
            int n3 = reader.Next(objectHandleHolder, statusCodeHolder);
            this.getFullDatabase().parseStatus(statusCodeHolder.value);
            if (n3 <= 0) break;
            if (n2 == 1) {
                object2 = new ArrayList<Object>();
                ((ArrayList)object2).add(object);
                object = object2;
            }
            CacheRootObject cacheRootObject = (CacheRootObject)objectHandleHolder.value;
            object2 = ObjectHandle.class.isAssignableFrom(clazz) ? cacheRootObject : cacheRootObject.detach(this.mManager.allowProxy());
            if (n2 > 0) {
                ((ArrayList)object).add(object2);
            } else {
                object = object2;
            }
            ++n2;
        }
        return object;
    }

    @Override
    public Map schemaStatus(Collection collection) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (String string : collection) {
            String string2 = null;
            try {
                string2 = this.mManager.findImplementationName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                treeMap.put(string, null);
                continue;
            }
            treeMap.put(string, new Integer(0));
        }
        return treeMap;
    }

    @Override
    public int getMemoryCacheSize(int n) {
        return this.mManager.manager().getMemoryCacheSize(n);
    }

    private Persistent getRunnableObject(Object object) throws Exception {
        Persistent persistent;
        if (object instanceof Persistent) {
            return (Persistent)object;
        }
        CacheClass cacheClass = this.findImplementation(object.getClass());
        cacheClass = this.getFullDatabase().getCacheClass(cacheClass.getName());
        if (this.amIUseLightConnection()) {
            Serializable serializable = this.mManager.save(object, true);
            persistent = (Persistent)cacheClass.openObject(new Id(serializable.toString()));
        } else {
            persistent = this.attachInternal(object, true);
        }
        return persistent;
    }

    private Database getFullDatabase() throws Exception {
        return this.mManager.getFullDatabase();
    }

    private Persistent attachInternal(Object object, boolean bl) throws Exception {
        return this.mManager.attachInternal(object, bl, true);
    }

    private CacheClass findImplementation(Class clazz) throws Exception {
        return this.mManager.findImplementation(clazz);
    }

    private boolean amIUseLightConnection() {
        return this.mManager.amIUseLightConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findSubClasses(String string) throws Exception {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = "select id from %Dictionary.CompiledClass where super LIKE '%";
        Statement statement = this.mManager.mDB.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(string2 + string + "%'");
            while (resultSet.next()) {
                object = resultSet.getString(1);
                arrayList.add(object);
                arrayList.addAll(Arrays.asList(this.findSubClasses((String)object)));
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 99) {
                throw new SQLException("Can not determine sublcasses of class " + string + ". Insufficient privillege to query Class Dictionary. " + "Please grant SELECT on %Dictionary.CompiledClass", sQLException.getSQLState(), sQLException.getErrorCode());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            statement.close();
        }
        object = new String[arrayList.size()];
        return arrayList.toArray((T[])object);
    }
}

