/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbcgateway;

import com.intersys.jdbcgateway.StreamContainer;
import com.intersys.transaction.CacheTransactionManager;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class JDBCGateway {
    ArrayList connList = new ArrayList();
    ArrayList stmtList = new ArrayList();
    ArrayList rsList = new ArrayList();
    HashMap connToSt = new HashMap();
    HashMap connToRs = new HashMap();
    HashMap stToRs = new HashMap();
    HashMap stToMd = new HashMap();
    HashMap stToStrCont = new HashMap();
    HashMap rsToLOB = new HashMap();
    HashMap stToLOB = new HashMap();
    SQLException sqlEx = null;
    Exception ex = null;
    boolean isXA = false;
    CacheTransactionManager transactionManager = null;
    Transaction transaction = null;

    public String getErrorText() {
        if (this.sqlEx == null) {
            return "";
        }
        return this.sqlEx.getMessage();
    }

    public String getString(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            return resultSet.getString(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String stgetString(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            return callableStatement.getString(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String stgetDate(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            Date date = callableStatement.getDate(n2);
            return date.toString();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String stgetTime(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            Time time = callableStatement.getTime(n2);
            return time.toString();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String stgetTimestamp(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            Timestamp timestamp = callableStatement.getTimestamp(n2);
            return timestamp.toString();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int setString(int n, int n2, String string) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            preparedStatement.setString(n2, string);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int setValue(int n, int n2, String string, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                int n4 = parameterMetaData.getParameterType(n2);
                if (string == null) {
                    preparedStatement.setNull(n2, n4);
                    return 0;
                }
                switch (n4) {
                    case 11: 
                    case 93: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 93);
                            break;
                        }
                        preparedStatement.setTimestamp(n2, Timestamp.valueOf(string));
                        break;
                    }
                    case 9: 
                    case 91: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 91);
                            break;
                        }
                        preparedStatement.setDate(n2, Date.valueOf(string.substring(0, 10)));
                        break;
                    }
                    case -5: {
                        if (string == null) {
                            preparedStatement.setNull(n2, -5);
                            break;
                        }
                        preparedStatement.setLong(n2, Long.parseLong(string));
                        break;
                    }
                    case 6: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 6);
                            break;
                        }
                        preparedStatement.setFloat(n2, Float.parseFloat(string));
                        break;
                    }
                    case 4: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 4);
                            break;
                        }
                        preparedStatement.setInt(n2, Integer.parseInt(string));
                        break;
                    }
                    case 8: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 8);
                            break;
                        }
                        preparedStatement.setDouble(n2, Double.parseDouble(string));
                        break;
                    }
                    case 3: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 3);
                            break;
                        }
                        preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                        break;
                    }
                    case 2: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 2);
                            break;
                        }
                        preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                        break;
                    }
                    case 5: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 5);
                            break;
                        }
                        preparedStatement.setShort(n2, Short.parseShort(string));
                        break;
                    }
                    case -7: 
                    case 16: {
                        if (string == null) {
                            preparedStatement.setNull(n2, n3);
                            break;
                        }
                        boolean bl = true;
                        if (string.equals("") || string.equals("0")) {
                            bl = false;
                        }
                        preparedStatement.setBoolean(n2, bl);
                        break;
                    }
                    default: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 1);
                            break;
                        }
                        preparedStatement.setString(n2, string);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                switch (n3) {
                    case 11: 
                    case 93: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 93);
                            break;
                        }
                        preparedStatement.setTimestamp(n2, Timestamp.valueOf(string));
                        break;
                    }
                    case 9: 
                    case 91: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 91);
                            break;
                        }
                        preparedStatement.setDate(n2, Date.valueOf(string.substring(0, 10)));
                        break;
                    }
                    case -5: {
                        if (string == null) {
                            preparedStatement.setNull(n2, -5);
                            break;
                        }
                        preparedStatement.setLong(n2, Long.parseLong(string));
                        break;
                    }
                    case 6: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 6);
                            break;
                        }
                        preparedStatement.setFloat(n2, Float.parseFloat(string));
                        break;
                    }
                    case 4: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 4);
                            break;
                        }
                        preparedStatement.setInt(n2, Integer.parseInt(string));
                        break;
                    }
                    case 8: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 8);
                            break;
                        }
                        preparedStatement.setDouble(n2, Double.parseDouble(string));
                        break;
                    }
                    case 3: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 3);
                            break;
                        }
                        preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                        break;
                    }
                    case 2: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 2);
                            break;
                        }
                        preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                        break;
                    }
                    case 5: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 5);
                            break;
                        }
                        preparedStatement.setShort(n2, Short.parseShort(string));
                        break;
                    }
                    case -7: 
                    case 16: {
                        if (string == null) {
                            preparedStatement.setNull(n2, n3);
                            break;
                        }
                        boolean bl = true;
                        if (string.equals("") || string.equals("0")) {
                            bl = false;
                        }
                        preparedStatement.setBoolean(n2, bl);
                        break;
                    }
                    default: {
                        if (string == null) {
                            preparedStatement.setNull(n2, 1);
                            break;
                        }
                        preparedStatement.setString(n2, string);
                    }
                }
            }
            return 0;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public int setValueDirect(int n, int n2, String string, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            if (string == null) {
                preparedStatement.setNull(n2, n3);
                return 0;
            }
            switch (n3) {
                case 11: 
                case 93: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 93);
                        break;
                    }
                    preparedStatement.setTimestamp(n2, Timestamp.valueOf(string));
                    break;
                }
                case 9: 
                case 91: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 91);
                        break;
                    }
                    preparedStatement.setDate(n2, Date.valueOf(string.substring(0, 10)));
                    break;
                }
                case -5: {
                    if (string == null) {
                        preparedStatement.setNull(n2, -5);
                        break;
                    }
                    preparedStatement.setLong(n2, Long.parseLong(string));
                    break;
                }
                case 6: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 6);
                        break;
                    }
                    preparedStatement.setFloat(n2, Float.parseFloat(string));
                    break;
                }
                case 4: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 4);
                        break;
                    }
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                    break;
                }
                case 2: 
                case 3: 
                case 8: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 2);
                        break;
                    }
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                    break;
                }
                case 5: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 5);
                        break;
                    }
                    preparedStatement.setShort(n2, Short.parseShort(string));
                    break;
                }
                case -7: 
                case 16: {
                    if (string == null) {
                        preparedStatement.setNull(n2, n3);
                        break;
                    }
                    boolean bl = true;
                    if (string.equals("") || string.equals("0")) {
                        bl = false;
                    }
                    preparedStatement.setBoolean(n2, bl);
                    break;
                }
                default: {
                    if (string == null) {
                        preparedStatement.setNull(n2, 1);
                        break;
                    }
                    preparedStatement.setString(n2, string);
                }
            }
            return 0;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public int registerOutParameter(int n, int n2, int n3) {
        this.sqlEx = null;
        if (n3 == 0) {
            n3 = 12;
        }
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            callableStatement.registerOutParameter(n2, n3);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public boolean wasError() {
        return this.sqlEx != null;
    }

    public boolean isXA() {
        return this.isXA;
    }

    public boolean next(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return false;
        }
    }

    public boolean cnext(int n) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return false;
        }
    }

    public String cgetString(int n, int n2) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            return resultSet.getString(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int cgetBLOB(int n, int n2) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            Blob blob = resultSet.getBlob(n2);
            if (blob == null) {
                return -1;
            }
            return this.addLOBToMap(blob, resultSet);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getBLOB(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            Blob blob = resultSet.getBlob(n2);
            if (blob == null) {
                return -1;
            }
            return this.addLOBToMap(blob, resultSet);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getCLOB(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            Clob clob = resultSet.getClob(n2);
            if (clob == null) {
                return -1;
            }
            return this.addLOBToMap(clob, resultSet);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getArgCLOB(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            Clob clob = callableStatement.getClob(n2);
            if (clob == null) {
                return -2;
            }
            return this.addStLOBToMap(clob, callableStatement);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getArgBLOB(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            Blob blob = callableStatement.getBlob(n2);
            if (blob == null) {
                return -1;
            }
            return this.addStLOBToMap(blob, callableStatement);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public byte[] cgetBLOBBytes(int n, int n2, long l, int n3) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            ArrayList arrayList = (ArrayList)this.rsToLOB.get(resultSet);
            Blob blob = (Blob)arrayList.get(n2);
            if (blob == null) {
                return null;
            }
            return blob.getBytes(l, n3);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return null;
        }
    }

    public String cgetCLOBSubstr(int n, int n2, long l, int n3) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            ArrayList arrayList = (ArrayList)this.rsToLOB.get(resultSet);
            Clob clob = (Clob)arrayList.get(n2);
            if (clob == null) {
                return null;
            }
            return clob.getSubString(l, n3);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return null;
        }
    }

    public byte[] getBLOBBytes(int n, int n2, long l, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            ArrayList arrayList = (ArrayList)this.rsToLOB.get(resultSet);
            Blob blob = (Blob)arrayList.get(n2);
            if (blob == null) {
                return null;
            }
            byte[] byArray = blob.getBytes(l, n3);
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return null;
        }
    }

    public byte[] getArgBLOBBytes(int n, int n2, long l, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ArrayList arrayList = (ArrayList)this.stToLOB.get(preparedStatement);
            Blob blob = (Blob)arrayList.get(n2);
            if (blob == null) {
                return null;
            }
            byte[] byArray = blob.getBytes(l, n3);
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return null;
        }
    }

    public String getCLOBSubstr(int n, int n2, long l, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            ArrayList arrayList = (ArrayList)this.rsToLOB.get(resultSet);
            Clob clob = (Clob)arrayList.get(n2);
            if (clob == null) {
                return null;
            }
            if (clob.length() + 1L >= l + (long)n3) {
                return clob.getSubString(l, n3);
            }
            String string = clob.getSubString(l, (int)(clob.length() - l + 1L));
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return null;
        }
    }

    public String getArgCLOBSubstr(int n, int n2, long l, int n3) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ArrayList arrayList = (ArrayList)this.stToLOB.get(preparedStatement);
            Clob clob = (Clob)arrayList.get(n2);
            if (clob == null) {
                return null;
            }
            if (clob.length() + 1L >= l + (long)n3) {
                return clob.getSubString(l, n3);
            }
            String string = clob.getSubString(l, (int)(clob.length() - l + 1L));
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return null;
        }
    }

    public int cgetCLOB(int n, int n2) {
        this.sqlEx = null;
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            Clob clob = resultSet.getClob(n2);
            if (clob == null) {
                return -1;
            }
            return this.addLOBToMap(clob, resultSet);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public ResultSet getRS(int n) {
        this.ex = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            return resultSet;
        }
        catch (Exception exception) {
            this.ex = exception;
            return null;
        }
    }

    public int execUpdate(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            return preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getUpdateCount(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            return preparedStatement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int connect(String string, String string2, String string3) {
        int n = -1;
        this.sqlEx = null;
        try {
            DriverManager.setLoginTimeout(30);
            Connection connection = DriverManager.getConnection(string, string2, string3);
            if (connection == null) {
                return n;
            }
            n = this.addConnection(connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n;
    }

    public int connectXA(String string, String string2) {
        int n = -1;
        this.sqlEx = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Class<?> clazz = Class.forName(string);
            XADataSource xADataSource = (XADataSource)clazz.newInstance();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken();
                if (((String)object3).indexOf(61) == -1) continue;
                object2 = ((String)object3).substring(0, ((String)object3).indexOf(61));
                object = ((String)object3).substring(((String)object3).indexOf(61) + 1);
                String string3 = "set" + (String)object2;
                Class[] classArray = new Class[1];
                Method method = null;
                Object[] objectArray = new Object[1];
                try {
                    classArray[0] = String.class;
                    method = clazz.getMethod(string3, classArray);
                    objectArray[0] = new String((String)object);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    classArray[0] = Integer.TYPE;
                    method = clazz.getMethod(string3, classArray);
                    objectArray[0] = new Integer((String)object);
                }
                method.invoke((Object)xADataSource, objectArray);
            }
            object3 = xADataSource.getXAConnection();
            object2 = object3.getXAResource();
            this.transaction.enlistResource((XAResource)object2);
            object = object3.getConnection();
            object.setAutoCommit(false);
            if (object == null) {
                return n;
            }
            n = this.addConnection(object);
        }
        catch (Exception exception) {
            this.ex = exception;
        }
        return n;
    }

    public int connectWithPropString(String string, String string2) {
        int n = -1;
        this.sqlEx = null;
        try {
            Object object;
            Properties properties = new Properties();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).indexOf(61) == -1) continue;
                String string3 = ((String)object).substring(0, ((String)object).indexOf(61));
                String string4 = ((String)object).substring(((String)object).indexOf(61) + 1);
                properties.put(string3, string4);
            }
            object = DriverManager.getConnection(string, properties);
            if (object == null) {
                return n;
            }
            n = this.addConnection(object);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n;
    }

    public int execQuery(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.addRsToMap((Object)preparedStatement, resultSet);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.addMdToMap(preparedStatement, resultSetMetaData);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getGeneratedKeys(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            this.addRsToMap((Object)preparedStatement, resultSet);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.addMdToMap(preparedStatement, resultSetMetaData);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int initStrCont(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            StreamContainer streamContainer = new StreamContainer();
            this.stToStrCont.put(preparedStatement, streamContainer);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    public int setBinaryStream(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            StreamContainer streamContainer = (StreamContainer)this.stToStrCont.get(preparedStatement);
            int n3 = streamContainer.getBinaryLength();
            if (n3 == 0) {
                preparedStatement.setNull(n2, -4);
                return 0;
            }
            preparedStatement.setBinaryStream(n2, streamContainer.getInputStream(), n3);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int setCharacterStream(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            StreamContainer streamContainer = (StreamContainer)this.stToStrCont.get(preparedStatement);
            int n3 = streamContainer.getStrLength();
            if (n3 == 0) {
                preparedStatement.setNull(n2, -1);
                return 0;
            }
            preparedStatement.setCharacterStream(n2, (Reader)streamContainer.getReader(), n3);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int addBytes(int n, byte[] byArray) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            StreamContainer streamContainer = (StreamContainer)this.stToStrCont.get(preparedStatement);
            return streamContainer.addBytes(byArray);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int addString(int n, String string) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            StreamContainer streamContainer = (StreamContainer)this.stToStrCont.get(preparedStatement);
            return streamContainer.addString(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int rmStrCont(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            this.stToStrCont.remove(preparedStatement);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    public int getResultSet(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            if (resultSet != null) {
                resultSet.close();
                this.stToRs.remove(preparedStatement);
                int n2 = this.rsList.indexOf(resultSet);
                if (n2 != -1) {
                    this.removeResultSet(n2);
                    this.rsList.set(n2, null);
                }
            }
            if ((resultSet = preparedStatement.getResultSet()) == null) {
                return -1;
            }
            this.addRsToMap((Object)preparedStatement, resultSet);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.addMdToMap(preparedStatement, resultSetMetaData);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getArgResultSet(int n, int n2) {
        this.sqlEx = null;
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)callableStatement.getObject(n2);
            this.addRsToMap((Object)callableStatement, resultSet);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.addMdToMap(callableStatement, resultSetMetaData);
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getMoreResults(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            boolean bl = preparedStatement.getMoreResults();
            if (!bl) {
                return 0;
            }
            return 1;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int execute(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            boolean bl = preparedStatement.execute();
            if (bl) {
                return 1;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getTables(int n, String string, String string2, String string3, String[] stringArray) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(string, string2, string3, stringArray);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getExportedKeys(int n, String string, String string2, String string3) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getExportedKeys(string, string2, string3);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getImportedKeys(int n, String string, String string2, String string3) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getImportedKeys(string, string2, string3);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getIndexInfo(int n, String string, String string2, String string3, boolean bl, boolean bl2) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getIndexInfo(string, string2, string3, bl, bl2);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getCrossReference(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getCrossReference(string, string2, string3, string4, string5, string6);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getColumns(int n, String string, String string2, String string3, String string4) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(string, string2, string3, string4);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getPrimaryKeys(int n, String string, String string2, String string3) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getProcedureColumns(int n, String string, String string2, String string3, String string4) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getProcedureColumns(string, string2, string3, string4);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getProcedures(int n, String string, String string2, String string3) {
        this.sqlEx = null;
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getProcedures(string, string2, string3);
            return this.addResultSet(resultSet, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int columnCount(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getColumnType(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnType(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public String getColumnTypeName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnTypeName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int getPrecision(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getPrecision(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getScale(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getScale(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getColumnDisplaySize(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnDisplaySize(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isCurrency(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            if (resultSetMetaData.isCurrency(n2)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isNullable(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.isNullable(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isAutoIncrement(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            if (resultSetMetaData.isAutoIncrement(n2)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isCaseSensitive(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            if (resultSetMetaData.isCaseSensitive(n2)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isReadOnly(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            if (resultSetMetaData.isReadOnly(n2)) {
                return 1;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public String getColumnName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String columnTypeName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnTypeName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int removeStatement(int n) {
        try {
            int n2;
            ResultSet resultSet;
            this.sqlEx = null;
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            if (preparedStatement instanceof CallableStatement) {
                this.removeAllArgLOBs(n);
            }
            if ((resultSet = (ResultSet)this.stToRs.get(preparedStatement)) != null) {
                n2 = this.rsList.indexOf(resultSet);
                if (n2 != -1) {
                    this.removeResultSet(n2);
                } else {
                    this.rsToLOB.remove(resultSet);
                }
                resultSet.close();
            }
            this.stToRs.remove(preparedStatement);
            this.stToMd.remove(preparedStatement);
            this.stToStrCont.remove(preparedStatement);
            this.stmtList.set(n, null);
            preparedStatement.close();
            for (n2 = 0; n2 < this.connList.size(); ++n2) {
                if (this.connList.get(n2) == null) continue;
                Connection connection = (Connection)this.connList.get(n2);
                try {
                    ArrayList arrayList = (ArrayList)this.connToSt.get(connection);
                    if (arrayList == null) continue;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Integer n3;
                        if (arrayList.get(i) == null || (n3 = (Integer)arrayList.get(i)) != n) continue;
                        arrayList.set(i, null);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int removeResultSet(int n) {
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            resultSet.close();
            this.removeAllLOBs(n);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        try {
            this.sqlEx = null;
            this.rsList.set(n, null);
            for (int i = 0; i < this.connList.size(); ++i) {
                if (this.connList.get(i) == null) continue;
                Connection connection = (Connection)this.connList.get(i);
                try {
                    ArrayList arrayList = (ArrayList)this.connToRs.get(connection);
                    if (arrayList == null) continue;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        Integer n2;
                        if (arrayList.get(j) == null || (n2 = (Integer)arrayList.get(j)) != n) continue;
                        arrayList.set(j, null);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int closeAll() {
        for (int i = 0; i < this.connList.size(); ++i) {
            if (this.connList.get(i) == null) continue;
            Connection connection = (Connection)this.connList.get(i);
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeConnection(i);
        }
        return 0;
    }

    public int removeConnection(int n) {
        try {
            ArrayList arrayList;
            Connection connection = (Connection)this.connList.get(n);
            connection.close();
            ArrayList arrayList2 = (ArrayList)this.connToSt.get(connection);
            if (arrayList2 != null) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (arrayList2.get(i) == null) continue;
                    Integer n2 = (Integer)arrayList2.get(i);
                    this.removeStatement(n2);
                }
            }
            if ((arrayList = (ArrayList)this.connToRs.get(connection)) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i) == null) continue;
                    Integer n3 = (Integer)arrayList.get(i);
                    this.removeResultSet(n3);
                }
            }
            this.connList.set(n, null);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int setAutoCommit(int n, boolean bl) {
        try {
            Connection connection = (Connection)this.connList.get(n);
            connection.setAutoCommit(bl);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int commitXA() {
        try {
            this.transactionManager.commit();
            this.transactionManager.begin();
            this.transaction = this.transactionManager.getTransaction();
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int rollbackXA() {
        try {
            this.transactionManager.rollback();
            this.transactionManager.begin();
            this.transaction = this.transactionManager.getTransaction();
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int commit(int n) {
        try {
            Connection connection = (Connection)this.connList.get(n);
            connection.commit();
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int rollback(int n) {
        try {
            Connection connection = (Connection)this.connList.get(n);
            connection.rollback();
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getColumnCount(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSetMetaData resultSetMetaData = (ResultSetMetaData)this.stToMd.get(preparedStatement);
            return resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getParameterCount(int n) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getParameterCount();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public String getParameterClassName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getParameterClassName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public String getParameterTypeName(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getParameterTypeName(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return "";
        }
    }

    public int getParameterMode(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getParameterMode(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getParameterType(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getParameterType(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getParameterPrecision(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getPrecision(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int getParameterScale(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getScale(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isParameterNullable(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.isNullable(n2);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int isParameterSigned(int n, int n2) {
        this.sqlEx = null;
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.isSigned(n2) ? 1 : 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return -1;
        }
    }

    public int prepareStatement(int n, String string) {
        this.sqlEx = null;
        int n2 = -1;
        try {
            Connection connection = (Connection)this.connList.get(n);
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            n2 = this.addStatement(preparedStatement, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n2;
    }

    public int prepareStatementGK(int n, String string) {
        this.sqlEx = null;
        int n2 = -1;
        try {
            Connection connection = (Connection)this.connList.get(n);
            PreparedStatement preparedStatement = connection.prepareStatement(string, 1);
            n2 = this.addStatement(preparedStatement, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n2;
    }

    public String getDatabaseProductName(int n) {
        this.sqlEx = null;
        String string = "";
        try {
            Connection connection = (Connection)this.connList.get(n);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            return string;
        }
    }

    public int prepareCall(int n, String string) {
        this.sqlEx = null;
        int n2 = -1;
        try {
            Connection connection = (Connection)this.connList.get(n);
            CallableStatement callableStatement = connection.prepareCall(string);
            n2 = this.addStatement(callableStatement, connection);
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
        }
        return n2;
    }

    public int setXAMode(int n) {
        for (int i = 0; i < this.connList.size(); ++i) {
            if (this.connList.get(i) == null) continue;
            return -1;
        }
        if (n == 1) {
            if (this.isXA) {
                return 1;
            }
            this.isXA = true;
            try {
                Class.forName("javax.transaction.Transaction");
                this.transactionManager = CacheTransactionManager.getTransactionManager();
                this.transactionManager.begin();
                this.transaction = this.transactionManager.getTransaction();
            }
            catch (Exception exception) {
                this.ex = exception;
                return -1;
            }
            return 1;
        }
        this.isXA = false;
        try {
            this.transactionManager = null;
        }
        catch (Exception exception) {
            this.ex = exception;
            return -1;
        }
        return 0;
    }

    private int addConnection(Object object) {
        for (int i = 0; i < this.connList.size(); ++i) {
            if (this.connList.get(i) != null) continue;
            this.connList.set(i, object);
            return i;
        }
        this.connList.add(object);
        return this.connList.size() - 1;
    }

    private void addStToMap(Object object, int n) {
        ArrayList arrayList;
        if (!this.connToSt.containsKey(object)) {
            arrayList = new ArrayList();
            this.connToSt.put(object, arrayList);
        } else {
            arrayList = (ArrayList)this.connToSt.get(object);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != null) continue;
            arrayList.set(i, new Integer(n));
            return;
        }
        arrayList.add(new Integer(n));
    }

    private void addRsToMap(Object object, int n) {
        ArrayList arrayList;
        if (!this.connToRs.containsKey(object)) {
            arrayList = new ArrayList();
            this.connToRs.put(object, arrayList);
        } else {
            arrayList = (ArrayList)this.connToRs.get(object);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != null) continue;
            arrayList.set(i, new Integer(n));
            return;
        }
        arrayList.add(new Integer(n));
    }

    public int removeLOB(int n, int n2) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)this.stmtList.get(n);
            ResultSet resultSet = (ResultSet)this.stToRs.get(preparedStatement);
            if (resultSet == null) {
                return 0;
            }
            ArrayList arrayList = (ArrayList)this.rsToLOB.get(resultSet);
            if (arrayList == null) {
                return 0;
            }
            if (n2 >= arrayList.size()) {
                return 0;
            }
            arrayList.set(n2, null);
            return 0;
        }
        catch (Exception exception) {
            this.ex = exception;
            return -1;
        }
    }

    public int removeArgLOB(int n, int n2) {
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            ArrayList arrayList = (ArrayList)this.stToLOB.get(callableStatement);
            if (arrayList == null) {
                return 0;
            }
            if (n2 >= arrayList.size()) {
                return 0;
            }
            arrayList.set(n2, null);
            return 0;
        }
        catch (Exception exception) {
            this.ex = exception;
            return -1;
        }
    }

    private void removeAllLOBs(int n) {
        try {
            ResultSet resultSet = (ResultSet)this.rsList.get(n);
            if (resultSet == null) {
                return;
            }
            ArrayList arrayList = (ArrayList)this.rsToLOB.get(resultSet);
            if (arrayList == null) {
                return;
            }
            arrayList = null;
            this.rsToLOB.remove(resultSet);
        }
        catch (Exception exception) {
            this.ex = exception;
        }
    }

    private void removeAllArgLOBs(int n) {
        try {
            CallableStatement callableStatement = (CallableStatement)this.stmtList.get(n);
            if (callableStatement == null) {
                return;
            }
            ArrayList arrayList = (ArrayList)this.stToLOB.get(callableStatement);
            if (arrayList == null) {
                return;
            }
            arrayList = null;
            this.stToLOB.remove(callableStatement);
        }
        catch (Exception exception) {
            this.ex = exception;
        }
    }

    private int addLOBToMap(Object object, Object object2) {
        ArrayList arrayList;
        if (!this.rsToLOB.containsKey(object2)) {
            arrayList = new ArrayList();
            this.rsToLOB.put(object2, arrayList);
        } else {
            arrayList = (ArrayList)this.rsToLOB.get(object2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != null) continue;
            arrayList.set(i, object);
            return i;
        }
        arrayList.add(object);
        return arrayList.size() - 1;
    }

    private int addStLOBToMap(Object object, Object object2) {
        ArrayList arrayList;
        if (!this.stToLOB.containsKey(object2)) {
            arrayList = new ArrayList();
            this.stToLOB.put(object2, arrayList);
        } else {
            arrayList = (ArrayList)this.stToLOB.get(object2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != null) continue;
            arrayList.set(i, object);
            return i;
        }
        arrayList.add(object);
        return arrayList.size() - 1;
    }

    private void addRsToMap(Object object, Object object2) {
        int n;
        ResultSet resultSet = (ResultSet)this.stToRs.get(object);
        if (resultSet != null) {
            n = this.rsList.indexOf(resultSet);
            this.removeResultSet(n);
        }
        this.stToRs.put(object, object2);
        for (n = 0; n < this.rsList.size(); ++n) {
            if (this.rsList.get(n) != null) continue;
            this.rsList.set(n, object2);
            return;
        }
        this.rsList.add(object2);
    }

    private void addMdToMap(Object object, Object object2) {
        this.stToMd.put(object, object2);
    }

    private int addStatement(Object object, Object object2) {
        for (int i = 0; i < this.stmtList.size(); ++i) {
            if (this.stmtList.get(i) != null) continue;
            this.stmtList.set(i, object);
            this.addStToMap(object2, i);
            return i;
        }
        this.stmtList.add(object);
        this.addStToMap(object2, this.stmtList.size() - 1);
        return this.stmtList.size() - 1;
    }

    private int addResultSet(Object object, Object object2) {
        for (int i = 0; i < this.rsList.size(); ++i) {
            if (this.rsList.get(i) != null) continue;
            this.rsList.set(i, object);
            this.addRsToMap(object2, i);
            return i;
        }
        this.rsList.add(object);
        this.addRsToMap(object2, this.rsList.size() - 1);
        return this.rsList.size() - 1;
    }
}

