/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.SysList;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public final class InStream {
    static final int FETCH_DATA = 1;
    static final int BYTE_STREAM = 2;
    LogFileStream logFile;
    public SysList wire;
    private byte[] header;
    private int messageLength;
    private int ID;
    private int count;
    private int error;
    private byte[] ucs2;
    private CacheConnection connection;
    private int highBit;
    InputStream inputStream;

    InStream(CacheConnection cacheConnection) throws IOException {
        this.inputStream = cacheConnection.inputStream;
        this.wire = new SysList();
        this.connection = cacheConnection;
        this.logFile = this.connection.logFile;
        this.header = new byte[14];
    }

    public InStream(InputStream inputStream, LogFileStream logFileStream) throws IOException {
        this.inputStream = inputStream;
        this.wire = new SysList();
        this.connection = null;
        this.logFile = logFileStream;
        this.header = new byte[14];
    }

    public void setConnection(CacheConnection cacheConnection) {
        this.connection = cacheConnection;
        this.wire.setConnectionInfo(this.connection.connectionInfo);
    }

    private synchronized void checkHeader(int n) throws SQLException {
        this.getHeader();
        this.messageLength = SysList.read4ByteInt(this.header, 0);
        this.count = SysList.read4ByteInt(this.header, 4);
        this.ID = SysList.read4ByteInt(this.header, 8);
        this.highBit = this.ID & Integer.MIN_VALUE;
        if (this.highBit != 0) {
            this.ID &= Integer.MAX_VALUE;
        }
        this.error = this.header[12] & 0xFF | (this.header[13] & 0xFF) << 8;
        if (this.count != this.connection.messageCount.count && !this.isJavaGatewayMessage()) {
            this.invalidMessageReceived();
        }
        if (n != this.ID && !this.isJavaGatewayMessage()) {
            this.connection.close();
            throw new SQLException("Invalid Statement Number (452); expected: " + n + " got: " + this.ID + ". Connection closed", "08S01", 452);
        }
    }

    synchronized void quickReadHeader() throws Exception {
        if (-1 == this.inputStream.read(this.header, 0, 14)) {
            throw new Exception("Error retrieving info: make sure your server supports GetNamespaces");
        }
        this.messageLength = SysList.read4ByteInt(this.header, 0);
        this.error = this.header[12] & 0xFF | (this.header[13] & 0xFF) << 8;
        if (this.error != 0) {
            throw new Exception("Error retrieving info: " + this.error);
        }
        this.wire.readData(this.inputStream, this.messageLength);
    }

    synchronized int readHeader(int n, int n2, int n3) throws SQLException {
        this.highBit = 1;
        try {
            if (n2 == 1) {
                int n4 = this.wire.resetFDRead();
                while (this.highBit != 0) {
                    this.checkHeader(n);
                    this.wire.readData(this.inputStream, this.messageLength);
                    if (this.logFile == null || this.highBit != 0) continue;
                    this.logFile.dump(this.wire, n4, 0, this.header);
                }
            } else if (n2 == 2) {
                this.ucs2 = null;
                while (this.highBit != 0) {
                    this.checkHeader(n);
                    this.readStream(this.messageLength);
                }
            } else {
                this.wire.resetRead();
                while (this.highBit != 0) {
                    this.checkHeader(n);
                    this.wire.readData(this.inputStream, this.messageLength);
                    if (this.logFile == null || this.highBit != 0) continue;
                    this.logFile.dump(this.wire, 0, 0, this.header);
                }
            }
            if (this.error != 0) {
                if (this.isJavaGatewayMessage()) {
                    this.javaGatewayCallback(n, n2 == 2, n2, n3);
                } else {
                    return this.connection.processError(this.error, n3);
                }
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new SQLException("Communication error: " + iOException.getMessage(), "08S01", 461);
        }
    }

    private final boolean isJavaGatewayMessage() {
        return (this.error & 0xFF) == 89;
    }

    byte[] getRawBytes() throws SQLException {
        return this.ucs2;
    }

    synchronized void readStream(int n) throws IOException {
        int n2;
        int n3;
        int n4 = n;
        if (this.ucs2 == null) {
            this.ucs2 = new byte[n];
            n3 = 0;
            n2 = 0;
        } else {
            byte[] byArray = new byte[this.ucs2.length + n];
            n2 = this.ucs2.length;
            System.arraycopy(this.ucs2, 0, byArray, 0, this.ucs2.length);
            n3 = this.ucs2.length;
            this.ucs2 = byArray;
        }
        while (n > 0) {
            int n5 = this.inputStream.read(this.ucs2, n3, n);
            n3 += n5;
            n -= n5;
        }
        if (this.logFile != null) {
            this.logFile.dump(this.ucs2, n2, n4, 0, this.header);
        }
    }

    public synchronized int readHeader() throws Exception {
        this.wire.resetRead();
        this.highBit = 1;
        while (this.highBit != 0) {
            this.getHeader();
            this.messageLength = SysList.read4ByteInt(this.header, 0);
            this.count = SysList.read4ByteInt(this.header, 4);
            this.ID = SysList.read4ByteInt(this.header, 8);
            this.highBit = this.ID & Integer.MIN_VALUE;
            this.wire.readData(this.inputStream, this.messageLength);
        }
        if (this.logFile != null) {
            this.logFile.dump(this.wire, 0, 0, this.header);
        }
        return this.header[13] - 48;
    }

    private synchronized void invalidMessageReceived() throws SQLException {
        try {
            int n;
            if (this.logFile != null && this.highBit == 0) {
                while ((n = this.inputStream.available()) >= 1) {
                    this.wire.readData(this.inputStream, n);
                }
                this.logFile.dump(this.wire, 0, 0, this.header);
            }
            n = this.connection.messageCount.count;
            this.connection.close();
            throw new SQLException("Invalid Message Count (452); expected: " + n + " got: " + this.count + ". Connection closed", "08S01", 452);
        }
        catch (IOException iOException) {
            throw new SQLException("Communication error: " + iOException.getMessage(), "08S01", 461);
        }
    }

    private void javaGatewayCallback(int n, boolean bl, int n2, int n3) throws SQLException {
        try {
            if (bl) {
                this.wire = new SysList(this.ucs2);
            }
            int n4 = this.connection.messageCount.count;
            Class[] classArray = new Class[]{CacheConnection.class, Integer.TYPE};
            Integer n5 = new Integer(this.header[13] - 48);
            Class<?> clazz = Class.forName("com.intersys.gateway.JavaGateway");
            clazz.getMethod("runJavaGateway", classArray).invoke(null, this.connection, n5);
            this.connection.messageCount.count = n4;
            if (n5 == 114) {
                this.readHeader(n, n2, n3);
                this.ucs2 = null;
            } else {
                this.ucs2 = this.wire.getData();
            }
        }
        catch (Exception exception) {
            throw new SQLException("JavaGateway Callback Error: " + exception.getMessage(), "08S01", 461);
        }
    }

    private void getHeader() throws SQLException {
        try {
            int n;
            if (-1 == n) {
                throw new SQLException("Server closed communication device");
            }
            for (n = this.inputStream.read(this.header, 0, 14); n != 14; n += this.inputStream.read(this.header, n, 14 - n)) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Communication error: " + iOException.getMessage(), "08S01", 461);
        }
    }
}

