/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.VersionInfo;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ConnectionPoolManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class CacheDriver
implements Driver {
    static ConnectionPoolManager CPManager;
    private static DriverPropertyInfo[] driverPropertyInfo;
    private String host;
    private String logFile;
    private int port;
    private String database;
    private String username = null;
    private String password = null;
    private String eventClass = "";
    private boolean nodelay = true;

    @Override
    public synchronized boolean acceptsURL(String string) throws SQLException {
        int n;
        if (!string.startsWith("jdbc:Cache://")) {
            return false;
        }
        String string2 = string.substring(13);
        if ((string2 = this.parseCredentials(string2)).startsWith("[")) {
            n = string2.indexOf("]");
            if (n == -1) {
                return false;
            }
            this.host = string2.substring(1, n);
            if (!(string2 = string2.substring(n + 1)).startsWith(":")) {
                return false;
            }
            n = (string2 = string2.substring(1)).indexOf("/");
            if (n == -1) {
                return false;
            }
        } else {
            n = string2.indexOf(":");
            if (n == -1) {
                return false;
            }
            this.host = string2.substring(0, n);
            if ((n = (string2 = string2.substring(n + 1)).indexOf("/")) == -1) {
                return false;
            }
        }
        this.port = Integer.parseInt(string2.substring(0, n));
        if ((n = (string2 = string2.substring(n + 1)).indexOf("/")) == -1) {
            this.database = string2;
            this.logFile = null;
            return true;
        }
        this.database = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 1)).indexOf(":")) == -1) {
            this.logFile = string2;
            if (this.logFile.equals("")) {
                this.logFile = null;
            }
            return true;
        }
        this.logFile = string2.substring(0, n);
        if (this.logFile.equals("")) {
            this.logFile = null;
        }
        string2 = string2.substring(n + 1);
        this.parseExtension(string2);
        return true;
    }

    private void parseExtension(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            this.eventClass = string;
        } else {
            this.eventClass = string.substring(0, n);
            if ((string = string.substring(n + 1)).equalsIgnoreCase("false")) {
                this.nodelay = false;
            }
        }
    }

    private String parseCredentials(String string) {
        int n = string.indexOf("?");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("username=");
        if (n2 != -1) {
            if ((n2 = (string2 = string2.substring(n2 + 9)).indexOf("&password=")) != -1) {
                this.username = string2.substring(0, n2);
                this.password = string2.substring(n2 + 10);
            } else {
                this.username = string2;
            }
        }
        return string.substring(0, n);
    }

    @Override
    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            return new CacheConnection(string, this.host, this.port, this.database, this.logFile, this.eventClass, this.nodelay, properties, this.username, this.password);
        }
        return null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return driverPropertyInfo;
    }

    @Override
    public int getMajorVersion() {
        return VersionInfo.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return VersionInfo.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            CacheDriver cacheDriver = new CacheDriver();
            CPManager = new ConnectionPoolManager();
            driverPropertyInfo = new DriverPropertyInfo[8];
            CacheDriver.driverPropertyInfo[0] = new DriverPropertyInfo("user", null);
            CacheDriver.driverPropertyInfo[0].description = "Username";
            CacheDriver.driverPropertyInfo[0].required = true;
            CacheDriver.driverPropertyInfo[1] = new DriverPropertyInfo("password", null);
            CacheDriver.driverPropertyInfo[1].description = "Password";
            CacheDriver.driverPropertyInfo[1].required = true;
            CacheDriver.driverPropertyInfo[2] = new DriverPropertyInfo("TCP_NODELAY", null);
            CacheDriver.driverPropertyInfo[2].description = "TCP/IP NoDelay Flag";
            CacheDriver.driverPropertyInfo[2].required = false;
            CacheDriver.driverPropertyInfo[2].choices = new String[]{"true", "false"};
            CacheDriver.driverPropertyInfo[3] = new DriverPropertyInfo("SO_SNDBUF", null);
            CacheDriver.driverPropertyInfo[3].description = "TCP/IP SO_SNDBUF value";
            CacheDriver.driverPropertyInfo[3].required = false;
            CacheDriver.driverPropertyInfo[4] = new DriverPropertyInfo("SO_RCVBUF", null);
            CacheDriver.driverPropertyInfo[4].description = "TCP/IP SO_RCVBUF value";
            CacheDriver.driverPropertyInfo[4].required = false;
            CacheDriver.driverPropertyInfo[5] = new DriverPropertyInfo("TransactionIsolationLevel", null);
            CacheDriver.driverPropertyInfo[5].description = "Transaction Isolation Level";
            CacheDriver.driverPropertyInfo[5].required = false;
            CacheDriver.driverPropertyInfo[5].choices = new String[]{"TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED"};
            CacheDriver.driverPropertyInfo[6] = new DriverPropertyInfo("service principal name", null);
            CacheDriver.driverPropertyInfo[6].description = "Service Principal Name";
            CacheDriver.driverPropertyInfo[6].required = false;
            CacheDriver.driverPropertyInfo[7] = new DriverPropertyInfo("connection security level", null);
            CacheDriver.driverPropertyInfo[7].description = "Connection Security Level";
            CacheDriver.driverPropertyInfo[7].required = false;
            CacheDriver.driverPropertyInfo[7].choices = new String[]{"1", "2", "3"};
            DriverManager.registerDriver(cacheDriver);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

