/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheOutputStream;
import com.intersys.jdbc.RealStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class CacheBlob
extends RealStream
implements Blob {
    CacheBlob(CacheConnection cacheConnection, byte[] byArray, int n, int n2, int n3) throws SQLException {
        super(cacheConnection, null, byArray, n, n2, n3, 0);
        this.getStreamSize();
    }

    CacheBlob(CacheConnection cacheConnection, String string, int n, int n2, int n3) throws SQLException {
        super(cacheConnection, string, null, n, n2, n3, 0);
        this.getSize();
    }

    CacheBlob(CacheConnection cacheConnection, byte[] byArray, int n) throws SQLException {
        super(cacheConnection, null, byArray, n, 1, -4, 0);
        this.getStreamSize();
    }

    @Override
    public long length() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return this.size;
    }

    @Override
    public synchronized byte[] getBytes(long l, int n) throws SQLException {
        return this.getByteStream(l, n);
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.streamOID != null) {
            return new CacheInputStream(this.connection, this.streamOID, this.cursorNumber, 1, this.sqlType, 0);
        }
        return new CacheInputStream(this.connection, (byte[])this.streamHandle, this.cursorNumber, 1);
    }

    @Override
    public synchronized long position(byte[] byArray, long l) throws SQLException {
        return this.getPosition(byArray, l);
    }

    @Override
    public synchronized long position(Blob blob, long l) throws SQLException {
        return this.getPosition(blob.getBytes(0L, (int)blob.length()), l);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        return new CacheOutputStream(this, l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3 = this.sendBytes(l, byArray, n, n2);
        this.getStreamSize();
        return n3;
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.truncateStream(l);
        this.getStreamSize();
    }

    @Override
    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error freeing blob " + exception.getMessage(), "S1000");
        }
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        return new CacheInputStream(this.getBytes(l, (int)l2), 1, this.sqlType, 0);
    }
}

