/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.gateway;

import com.intersys.gateway.GatewayException;
import com.intersys.gateway.JavaGateway;
import com.intersys.jdbc.LogFileStream;
import java.net.ServerSocket;
import java.net.Socket;

public class JDBCGateway
extends JavaGateway {
    protected JDBCGateway(Socket socket, int n, LogFileStream logFileStream) throws Exception {
        super(socket, n, logFileStream);
    }

    public static void main(String[] stringArray) throws Exception {
        LogFileStream logFileStream = null;
        if (stringArray.length == 0) {
            throw new GatewayException("Port number must be supplied as the first command line argument");
        }
        int n = Integer.parseInt(stringArray[0]);
        if (stringArray.length > 1 && stringArray.length == 2) {
            logFileStream = new LogFileStream(stringArray[1]);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            while (true) {
                Socket socket = serverSocket.accept();
                socket.setTcpNoDelay(true);
                socket.setReuseAddress(true);
                new JDBCGateway(socket, n, logFileStream).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GatewayException("[JDBC Gateway] Communication link failure: " + exception.getMessage());
        }
    }
}

