/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.classes.ListBuffer;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SysAbstractList;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.SystemError;
import java.util.AbstractList;

public abstract class AbstractCacheList
extends AbstractList
implements ObjectHandle {
    protected SysAbstractList mInternal;
    private ListBuffer mBuffer = null;

    protected abstract Object valueExternal2internal(Object var1);

    protected abstract Object valueInternal2external(Object var1) throws CacheException;

    @Override
    public int size() {
        try {
            return this._count();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object get(int n) {
        try {
            return this._getAt(new Integer(n + 1));
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public boolean add(Object object) {
        try {
            this._insert(this.valueExternal2internal(object));
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
        return true;
    }

    @Override
    public Object set(int n, Object object) {
        Object object2 = this.get(n);
        try {
            this._setAt(new Integer(n + 1), object);
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
        return object2;
    }

    @Override
    public void add(int n, Object object) {
        try {
            this._insertAt(new Integer(n + 1), object);
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object remove(int n) {
        try {
            return this._removeAt(new Integer(n + 1));
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public int indexOf(Object object) {
        try {
            Integer n = this._find(this.valueExternal2internal(object), null);
            if (n != null) {
                return n - 1;
            }
            return -1;
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public void clear() {
        try {
            this._clear();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    public Integer _count() throws CacheException {
        if (this.mBuffer != null) {
            return new Integer(this.mBuffer.count());
        }
        return this.getInternal()._count();
    }

    public Object _getAt(Integer n) throws CacheException {
        Object object = this.mBuffer != null ? this.mBuffer._getAt(n) : this.getInternal()._getAt(n);
        return this.valueInternal2external(object);
    }

    public void _insert(Object object) throws CacheException {
        this.invalidateCache();
        this.getInternal()._insert(this.valueExternal2internal(object));
    }

    public void _insertAt(Integer n, Object object) throws CacheException {
        this.invalidateCache();
        this.getInternal()._insertAt(n, this.valueExternal2internal(object));
    }

    public void _setAt(Integer n, Object object) throws CacheException {
        this.invalidateCache();
        this.getInternal()._setAt(n, (String)this.valueExternal2internal(object));
    }

    public Object _removeAt(Integer n) throws CacheException {
        this.invalidateCache();
        return this.valueInternal2external(this.getInternal()._removeAt(n));
    }

    public Integer _find(Object object, Integer n) throws CacheException {
        return this.getInternal()._find((String)object, n);
    }

    public void _clear() throws CacheException {
        this.invalidateCache();
        this.getInternal()._clear();
    }

    private SysAbstractList getInternal() {
        return this.mInternal;
    }

    @Override
    public CacheObject getProxy() {
        return this.mInternal.getProxy();
    }

    public RegisteredObject getRegisteredObject() throws CacheException {
        return this.mInternal;
    }

    public int getBufferSize() {
        if (this.mBuffer != null) {
            return this.mBuffer.getBufferSize();
        }
        return 0;
    }

    public static int getDefaultBufferSize() {
        return ListBuffer.getDefaultBufferSize();
    }

    public static void setDefaultBufferSize(int n) {
        ListBuffer.setDefaultBufferSize(n);
    }

    public boolean getAutoLoad() throws CacheException {
        if (this.mBuffer != null) {
            return this.mBuffer.getAutoLoad();
        }
        throw new CacheException("This List does not support bufferization.");
    }

    public void setAutoLoad(boolean bl) throws CacheException {
        if (this.mBuffer == null) {
            throw new CacheException("This List does not support bufferization.");
        }
        this.mBuffer.setAutoLoad(bl);
    }

    protected void setBuffer(ListBuffer listBuffer) throws CacheException {
        if (this.mBuffer != null) {
            throw new SystemError("Buffer already set.");
        }
        this.mBuffer = listBuffer;
    }

    public void close() throws CacheException {
        if (this.mBuffer != null) {
            this.mBuffer.close(true);
        }
    }

    @Override
    public int getOref() throws ObjectClosedException {
        return this.mInternal.getOref();
    }

    @Override
    public final Object getZRef() throws CacheException {
        return this.mInternal.getZRef();
    }

    @Override
    public Database getDatabase() {
        return this.mInternal.getDatabase();
    }

    @Override
    public void _close() throws CacheException {
        this.close();
    }

    @Override
    public String _className() throws CacheException {
        return this.mInternal._className();
    }

    @Override
    public String _className(Boolean bl) throws CacheException {
        return this.mInternal._className(bl);
    }

    @Override
    public Integer _isModified() throws CacheException {
        return this.mInternal._isModified();
    }

    @Override
    public void _normalizeObject() throws CacheException {
        this.mInternal._normalizeObject();
    }

    @Override
    public String _packageName() throws CacheException {
        return this.mInternal._packageName();
    }

    @Override
    public void _validateObject() throws CacheException {
        this.mInternal._validateObject();
    }

    @Override
    public void _validateObject(Integer n) throws CacheException {
        this.mInternal._validateObject(n);
    }

    protected void invalidateCache() throws CacheException {
        if (this.mBuffer != null) {
            this.mBuffer.invalidateCache(true);
        }
    }

    @Override
    public String toString() {
        return this.mInternal.toString() + ": " + super.toString();
    }
}

