/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectServerInfo;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QuickDBAdapter
extends JDBCAdapter
implements DBAdapter {
    private ObjectServerInfo mServerInfo;
    private Boolean mUseSeparateStreamQS = null;
    private QuickStatement mQS;
    private Map mStreamHandlers;

    public QuickDBAdapter(CacheConnection cacheConnection, ObjectServerInfo objectServerInfo) throws CacheException {
        super(cacheConnection);
        this.mConnectionInfo = cacheConnection.getConnectionInfo();
        this.mServerInfo = objectServerInfo;
        try {
            this.mQS = cacheConnection.createQuickStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to initialize QuickStatement");
        }
        this.mStreamHandlers = new HashMap();
    }

    public Object queryLoad(QuickStatement quickStatement, int n, String string, String string2, int n2, Object object) throws CacheServerException {
        Object object2;
        long l = System.currentTimeMillis();
        try {
            object2 = quickStatement.query(n, string, string2, n2, object);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load objects of class " + string2 + " by query \"" + string + "\"");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("QUERY_LOAD", l, l2);
        return object2;
    }

    @Override
    public Object load(String string, String string2, Object object, int n, TableBasedClass tableBasedClass) throws CacheServerException {
        Object object2;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.load(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to fetch row in table " + string + "." + string2 + " with id " + object);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("LOAD", l, l2);
        return object2;
    }

    @Override
    public Object loadByKey(String string, String string2, CandidateKey candidateKey, int n, TableBasedClass tableBasedClass) throws CacheException {
        Object object;
        if (candidateKey.isIdKey()) {
            String string3 = candidateKey.toIdValue();
            return this.load(string, string2, string3, n, tableBasedClass);
        }
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            if (candidateKey.isPrimaryKey()) {
                object = this.mQS.loadByPk(string, string2, candidateKey.toSysList(), n);
            } else {
                Object object2 = this.mQS.findRowIdByConstraint(string, string2, candidateKey.getSQLName(), candidateKey.toSysList(), 12);
                if (object2 == null) {
                    return null;
                }
                object = this.mQS.load(string, string2, object2, n);
                ++mNumCalls;
                for (int i = 0; i < n2; ++i) {
                    if (!mProfileFlag[i]) continue;
                    int n3 = i;
                    mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to fetch row in table " + string + "." + string2 + " with primary key " + candidateKey.toString());
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("LOAD_BY_KEY", l, l2);
        return object;
    }

    @Override
    public boolean deleteByKey(String string, String string2, CandidateKey candidateKey, int n, TableBasedClass tableBasedClass) throws CacheException {
        int n2 = mProfileFlag != null ? mProfileFlag.length : 0;
        long l = System.currentTimeMillis();
        try {
            if (candidateKey.isPrimaryKey()) {
                this.mQS.removeByPk(string, string2, candidateKey.toSysList(), n);
            } else {
                Object object = this.mQS.findRowIdByConstraint(string, string2, candidateKey.getSQLName(), candidateKey.toSysList(), 12);
                this.mQS.remove(string, string2, object, n);
                ++mNumCalls;
                for (int i = 0; i < n2; ++i) {
                    if (!mProfileFlag[i]) continue;
                    int n3 = i;
                    mNumCallsArray[n3] = mNumCallsArray[n3] + 1;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to delete row in table " + string + "." + string2 + " with primary key " + candidateKey.toString());
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("DELETE_BY_KEY", l, l2);
        return true;
    }

    @Override
    public Object existsForKey(String string, String string2, CandidateKey candidateKey) throws CacheException {
        long l = System.currentTimeMillis();
        Object object = null;
        try {
            object = candidateKey.isPrimaryKey() ? this.mQS.findRowIdByPrimaryKey(string, string2, candidateKey.toSysList(), 12) : this.mQS.findRowIdByConstraint(string, string2, candidateKey.getSQLName(), candidateKey.toSysList(), 12);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to find row in table " + string + "." + string2 + " with primary key " + candidateKey.toString());
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("EXISTS_FOR_KEY", l, l2);
        return object;
    }

    @Override
    public Object bulkLoad(String string, String string2, Object object, int n) throws CacheServerException {
        Object object2;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.bulkLoad(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to fetch rows in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("BULK_LOAD", l, l2);
        return object2;
    }

    @Override
    public ArrayList getListAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws CacheException {
        ArrayList arrayList;
        long l = System.currentTimeMillis();
        try {
            switch (n4) {
                case 4608: {
                    arrayList = this.mQS.getListOfReferencesAsChildTable(string, string2, object, n, n2, n3);
                    break;
                }
                case 8704: {
                    arrayList = this.mQS.getListOfSerialsAsChildTable(string, string2, object, n, n3);
                    break;
                }
                case 256: {
                    arrayList = this.mQS.getListOfDatatypesAsChildTable(string, string2, object, n, n2, n3);
                    break;
                }
                default: {
                    throw new CacheException("Type not supported: " + n4);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load child table " + string2);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("GET_CHILD_TABLE", l, l2);
        return arrayList;
    }

    @Override
    public HashMap getArrayAsChildTable(String string, String string2, Object object, int n, int n2, int n3, int n4) throws CacheException {
        HashMap hashMap;
        long l = System.currentTimeMillis();
        try {
            switch (n4) {
                case 4608: {
                    hashMap = this.mQS.getArrayOfReferencesAsChildTable(string, string2, object, n, 12, n2, n3);
                    break;
                }
                case 8704: {
                    hashMap = this.mQS.getArrayOfSerialsAsChildTable(string, string2, object, n, 12, n3);
                    break;
                }
                case 256: {
                    hashMap = this.mQS.getArrayOfDatatypesAsChildTable(string, string2, object, n, 12, n2, n3);
                    break;
                }
                default: {
                    throw new CacheException("Type not supported: " + n4);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to load child table " + string2);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("GET_CHILD_TABLE", l, l2);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object bulkCreate(String string, String string2, int n, Object object, int n2) throws CacheServerException {
        long l = System.currentTimeMillis();
        Object object2 = null;
        try {
            QuickStatement quickStatement = this.mQS;
            synchronized (quickStatement) {
                Object object3 = this.mQS.bulkCreate(string, string2, n, object, n2);
                object2 = SysListProxy.createSysList(SysListProxy.getBinaryData(object3), true, SysListProxy.getConnectionInfo(object3));
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Creating of objects failed.");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("BULK_CREATE", l, l2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkCreateNoIds(String string, String string2, int n, Object object, int n2) throws CacheServerException {
        long l = System.currentTimeMillis();
        try {
            QuickStatement quickStatement = this.mQS;
            synchronized (quickStatement) {
                this.mQS.bulkCreate(string, string2, n, object, n2);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Creating of objects failed.");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("BULK_CREATE", l, l2);
    }

    @Override
    public void bulkStore(String string, String string2, Object object, int n) throws CacheServerException {
        Object object2;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.bulkStore(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Creating of objects failed");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("BULK_STORE", l, l2);
        int n2 = 1;
        while (!SysListProxy.atEnd(object2)) {
            int n3;
            block9: {
                n3 = 0;
                Object object3 = null;
                Object object4 = null;
                try {
                    object3 = SysListProxy.getWrappedItem(object2);
                    n3 = SysListProxy.getInteger(object3);
                }
                catch (SQLException sQLException) {
                    try {
                        if (object3 != null) {
                            SysListProxy.rewind(object3);
                            object4 = SysListProxy.getObject(object3);
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    if (object4 != null) break block9;
                    throw new CacheServerException(sQLException, "Invalid response from BULK STORE request.");
                }
            }
            if (n3 < 0) {
                throw new CacheServerException("Unidentified error occured storing object # " + n2 + " in store list");
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object bulkSaveByPK(String string, String string2, Object object, int n) throws CacheServerException {
        Object object2;
        long l = System.currentTimeMillis();
        try {
            QuickStatement quickStatement = this.mQS;
            synchronized (quickStatement) {
                Object object3 = this.mQS.bulkSaveByPK(string, string2, object, n);
                object2 = SysListProxy.createSysList(SysListProxy.getBinaryData(object3), true, SysListProxy.getConnectionInfo(object3));
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Creating of objects failed");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("BULK_SAVE_BY_PK", l, l2);
        return object2;
    }

    @Override
    public Object create(String string, String string2, int n, Object object, int n2, TableBasedClass tableBasedClass) throws CacheServerException {
        Object object2;
        long l = System.currentTimeMillis();
        try {
            object2 = this.mQS.create(string, string2, n, object, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create an object in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("CREATE", l, l2);
        return object2;
    }

    @Override
    public void childTableRowRemove(String string, String string2, Object object, int n) throws CacheServerException {
        long l = System.currentTimeMillis();
        try {
            this.mQS.removeChildTable(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to remove objects from table " + string + "." + string2 + " where parent id = " + object);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("REMOVE_FROM_CHILD_TABLE", l, l2);
    }

    @Override
    public Object childTableRowInsert(String string, String string2, int n, Object object, Object object2, int n2) throws CacheServerException {
        Object object3;
        long l = System.currentTimeMillis();
        try {
            object3 = this.mQS.childTableRowInsert(string, string2, n, object, object2, n2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create an object in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("INSERT_INTO_CHILD_TABLE", l, l2);
        return object3;
    }

    @Override
    public void store(String string, String string2, Object object, Object object2, int n, TableBasedClass tableBasedClass) throws CacheServerException {
        long l = System.currentTimeMillis();
        try {
            this.mQS.store(string, string2, object, object2, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to update an object in table " + string + "." + string2);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("STORE", l, l2);
    }

    @Override
    public Object wrapBinaryStream(InputStream inputStream, QuickCacheObject quickCacheObject) throws CacheException {
        Object object;
        if (inputStream == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        try {
            QuickStatement quickStatement = this.getStreamHandler(quickCacheObject);
            object = quickStatement.setStream(quickStatement.wrapBinaryStream(inputStream));
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap binary stream");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("SET_BINARY_STREAM", l, l2);
        return object;
    }

    @Override
    public Object wrapCharacterStream(Reader reader, QuickCacheObject quickCacheObject) throws CacheException {
        Object object;
        long l = System.currentTimeMillis();
        try {
            QuickStatement quickStatement = this.getStreamHandler(quickCacheObject);
            object = quickStatement.setReader(quickStatement.wrapReader(reader));
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to wrap reader");
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("SET_READER", l, l2);
        return object;
    }

    private QuickStatement getStreamHandler(QuickCacheObject quickCacheObject) throws SQLException {
        if (!this.useSeparateStreamQS()) {
            return this.mQS;
        }
        QuickStatement quickStatement = (QuickStatement)this.mStreamHandlers.get(quickCacheObject);
        if (quickStatement == null) {
            CacheConnection cacheConnection = (CacheConnection)this.mConnection;
            quickStatement = cacheConnection.createQuickStatement();
            this.mStreamHandlers.put(quickCacheObject, quickStatement);
        }
        return quickStatement;
    }

    @Override
    public void clearStreamHandler(QuickCacheObject quickCacheObject) throws CacheException {
        QuickStatement quickStatement = (QuickStatement)this.mStreamHandlers.get(quickCacheObject);
        if (quickStatement == null) {
            return;
        }
        try {
            quickStatement.close();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException);
        }
        this.mStreamHandlers.remove(quickCacheObject);
    }

    @Override
    public InputStream getBinaryStream(Object object) throws SQLException {
        long l = System.currentTimeMillis();
        CacheInputStream cacheInputStream = this.mQS.getBinaryStream(object);
        long l2 = System.currentTimeMillis();
        this.afterMessage("GET_BINARY_STREAM", l, l2);
        return cacheInputStream;
    }

    @Override
    public Reader getReader(Object object) throws SQLException {
        long l = System.currentTimeMillis();
        CacheReader cacheReader = this.mQS.getReader(object);
        long l2 = System.currentTimeMillis();
        this.afterMessage("GET_READER", l, l2);
        return cacheReader;
    }

    @Override
    public void remove(String string, String string2, Object object, int n) throws CacheServerException {
        long l = System.currentTimeMillis();
        try {
            this.mQS.remove(string, string2, object, n);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to delete object from table " + string + '.' + string2 + " with id: " + object);
        }
        long l2 = System.currentTimeMillis();
        this.afterMessage("REMOVE", l, l2);
    }

    @Override
    public Connection getConnection() {
        return this.mConnection;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof QuickDBAdapter)) {
            return false;
        }
        QuickDBAdapter quickDBAdapter = (QuickDBAdapter)object;
        return this.mQS.equals(quickDBAdapter.mQS);
    }

    private boolean useSeparateStreamQS() {
        if (this.mUseSeparateStreamQS == null) {
            this.mUseSeparateStreamQS = this.mServerInfo.getMajorObjectVersion() < 2007 ? new Boolean(false) : (this.mServerInfo.getMajorObjectVersion() > 2007 ? new Boolean(true) : (this.mServerInfo.getMinorObjectVersion() > 1 ? new Boolean(true) : (this.mServerInfo.getMinorObjectBuildNumber() > 306 ? new Boolean(true) : new Boolean(false))));
        }
        return this.mUseSeparateStreamQS;
    }

    private void afterMessage(String string, long l, long l2) {
        QuickDBAdapter.updateProfiler(l, l2, string);
        this.log(string);
    }

    private void log(String string) {
        if (Logger.logTransactionState()) {
            int n;
            CacheConnection cacheConnection = (CacheConnection)this.mConnection;
            if (cacheConnection.getProtocolVersion() < 41) {
                return;
            }
            try {
                n = cacheConnection.inTransaction() ? 1 : 0;
            }
            catch (SQLException sQLException) {
                if (Logger.debugOn()) {
                    sQLException.printStackTrace(Logger.out);
                }
                return;
            }
            Logger.out.println("After Message " + string + " $tlevel = " + n);
        }
    }
}

