/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.Logger;
import com.intersys.objects.MessageListener;
import com.intersys.objects.SystemError;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

class ServerOutputProcessor {
    JBindDatabase mDB;

    public ServerOutputProcessor(JBindDatabase jBindDatabase) {
        this.mDB = jBindDatabase;
    }

    protected void evalUserErrors(Object object) throws CacheException {
        Object object2 = null;
        int n = -1;
        try {
            byte[] byArray = SysListProxy.getByte(object);
            if (byArray == null) {
                return;
            }
            object2 = SysListProxy.createSysList(byArray, false, SysListProxy.getConnectionInfo(object));
            if (object2 != null && !SysListProxy.atEnd(object2)) {
                ErrorData errorData = this.evalError(object2);
                CacheServerException cacheServerException = new CacheServerException(errorData.message, errorData.code);
                if (Logger.debugOn()) {
                    cacheServerException.printFullTrace(Logger.out);
                }
                throw cacheServerException;
            }
        }
        catch (SQLException sQLException) {
            if (n > 0) {
                throw new CacheException("Unknown error", n, sQLException);
            }
            throw new CacheServerException(sQLException, "Unable to get user error information");
        }
    }

    protected void evalServerErrors(Object object) throws CacheException {
        Object object2 = null;
        ErrorData errorData = null;
        try {
            object2 = SysListProxy.getSysList(object);
            if (object2 != null && !SysListProxy.atEnd(object2)) {
                object2 = SysListProxy.getSysList(object2);
                errorData = this.evalError(object2);
                CacheServerException cacheServerException = new CacheServerException(errorData.message, errorData.code);
                if (Logger.debugOn()) {
                    cacheServerException.printFullTrace(Logger.out);
                }
                throw cacheServerException;
            }
        }
        catch (SQLException sQLException) {
            if (errorData != null && errorData.code > 0) {
                throw new CacheException("Unknown error while closing objects", errorData.code, sQLException);
            }
            throw new CacheServerException(sQLException, "Unable to get server error information for error while closing objects");
        }
    }

    protected void evalResultList(Object object) throws CacheException {
        this.evalUserErrors(object);
        this.evalServerErrors(object);
        this.evalMessages(object);
    }

    protected void evalClosingErrros(Object object, List list) {
        try {
            this.evalServerErrors(object);
            object = SysListProxy.getSysList(object);
            if (object != null && !SysListProxy.atEnd(object)) {
                ErrorData errorData = this.evalError(object);
                if (errorData.code == -8) {
                    object = errorData.data;
                } else {
                    object = null;
                    list.add(new CacheServerException(errorData.message, errorData.code));
                }
            }
        }
        catch (Throwable throwable) {
            list.add(throwable);
        }
    }

    private void evalMessages(Object object) throws CacheException {
        try {
            String string;
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n = SysListProxy.getInteger(object);
            for (int i = 0; i < n; ++i) {
                string = SysListProxy.getString(object);
                if (string == null) continue;
                stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0) {
                string2 = stringBuffer.toString();
            }
            if (string2 == null) {
                return;
            }
            Iterator iterator = this.mDB.messageListneres();
            while (iterator.hasNext()) {
                string = iterator.next();
                if (!(string instanceof MessageListener)) continue;
                ((MessageListener)((Object)string)).messageReceived(string2);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Error extarcting server's message");
        }
    }

    private ErrorData evalError(Object object) throws CacheException {
        Object object2;
        ErrorData errorData = new ErrorData();
        try {
            object2 = SysListProxy.getString(object);
            errorData.code = Integer.parseInt((String)object2);
            errorData.message = SysListProxy.getString(object);
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Failed to interpret error information, code = " + errorData.code);
        }
        if (!SysListProxy.atEnd(object)) {
            try {
                object2 = SysListProxy.getSysList(object);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to get error info");
            }
            if (errorData.code == -7) {
                errorData.message = ServerOutputProcessor.getClosingErrorMessage(object2);
            } else if (errorData.code == -8) {
                errorData.data = object2;
            } else if (errorData.code == -9) {
                errorData.data = object2;
                try {
                    SysListProxy.skip(object2, 1);
                    object2 = SysListProxy.getByte(object2);
                }
                catch (SQLException sQLException) {
                    throw new CacheException("Failed to get error info for error -9", -9, sQLException);
                }
                Dataholder dataholder = new Dataholder(23, object2);
                this.mDB.parseStatus(dataholder);
            }
        }
        return errorData;
    }

    private static String getClosingErrorMessage(Object object) throws CacheException {
        try {
            int n = SysListProxy.getInteger(object);
            int n2 = SysListProxy.getInteger(object);
            String string = SysListProxy.atEnd(object) ? "" : SysListProxy.getString(object);
            return "Error while closing objects: Failed to decrease reference count for oref " + n + " by " + n2 + " " + string;
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to interpret closing error");
        }
    }

    protected Dataholder[] evalMethodReturnA(Object object, Dataholder[] dataholderArray, int[] nArray, int n, String string) throws CacheException {
        int n2;
        Dataholder[] dataholderArray2 = new Dataholder[nArray.length + 1];
        for (int i = 1; i < dataholderArray2.length && (n2 = nArray[i - 1] - 1) < dataholderArray.length; ++i) {
            if (n2 < 0) continue;
            int n3 = dataholderArray[n2].getType();
            boolean bl = n3 == 512 || n3 == 1026;
            dataholderArray2[i] = this.getValue(object, bl, true, string);
        }
        dataholderArray2[0] = n == 1 ? this.getValue(object, true, true, string) : (n != 3 ? this.getValue(object, false, true, string) : null);
        return dataholderArray2;
    }

    private Dataholder getValue(Object object, boolean bl, boolean bl2, String string) throws CacheException {
        try {
            if (bl) {
                return this.mDB.getServerObject(object, bl2);
            }
            Object object2 = SysListProxy.getWrappedItem(object);
            return new Dataholder(4096, object2);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, string);
        }
    }

    private static class ErrorData {
        public int code;
        public String message;
        public Object data;

        private ErrorData() {
        }
    }
}

