/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.CacheIface;
import com.intersys.cache.jbind.JBindCacheObject;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.cache.jbind.UnsetProperties;
import com.intersys.cache.jbind.ZObjectValueRep;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.metadata.AbstractCacheClass;
import com.intersys.classes.ObjectHandle;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CacheProcessor
implements CacheIface {
    private JBindDatabase mDB;
    private Map mTempMap;
    private boolean mAssertZobjVal;
    private UnsetProperties m_unset_props = new UnsetProperties();

    public CacheProcessor(JBindDatabase jBindDatabase) {
        this.mDB = jBindDatabase;
        this.mTempMap = Collections.synchronizedMap(new HashMap());
        this.mAssertZobjVal = ConnectionUtils.determineAssertZobjVal();
    }

    @Override
    public boolean find(int n) throws SystemError {
        JBindCacheObject jBindCacheObject = this.mDB.find(n);
        if (jBindCacheObject == null) {
            return false;
        }
        return jBindCacheObject.isZobjvalCached();
    }

    @Override
    public void remove(int n) throws SystemError {
        JBindCacheObject jBindCacheObject = this.mDB.find(n);
        if (jBindCacheObject == null) {
            return;
        }
        jBindCacheObject.invalidateZobjval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getData(Object object, Map map, CacheServerSensitive cacheServerSensitive, boolean bl) throws CacheException {
        try {
            int n = SysListProxy.getInteger(object);
            if (Logger.getDebugCache()) {
                Logger.out.println("Received " + n + " changed orefs " + "in cache from server");
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < n; ++i) {
                int n2 = SysListProxy.getInteger(object);
                hashSet.add(new Integer(n2));
                Object object2 = null;
                object2 = SysListProxy.getSysList(object);
                if (Logger.getDebugCache()) {
                    Logger.out.println("Got oid = " + object2);
                }
                int n3 = SysListProxy.getInteger(object);
                ZObjectValueRep zObjectValueRep = this.getZobjval(n2, n3, object2, bl);
                Map map2 = zObjectValueRep.getValueMap();
                PrintWriter printWriter = null;
                if (Logger.getDebugCache()) {
                    Logger.out.println("Got oref=" + n2 + "; nnodes=" + n3);
                    printWriter = Logger.out;
                }
                for (int j = 0; j < n3; ++j) {
                    int n4;
                    int n5;
                    try {
                        n5 = CacheProcessor.processNode(map2, object, printWriter, this.m_unset_props, n2);
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException, "Failed to extract server data for cache");
                    }
                    if (n5 >= 0) continue;
                    int n6 = this.getIdNode(n2, -n5);
                    if (n6 < 0) {
                        n6 = -n5 + 1;
                    }
                    if ((n4 = CacheProcessor.checkOrefSlotNode(zObjectValueRep, n6)) <= 0) continue;
                    hashSet.add(new Integer(n4));
                }
                if (!this.mAssertZobjVal) continue;
                Object[][] objectArray = this.mDB.getZobjVal(n2);
                String[] stringArray = (String[])objectArray[0];
                zObjectValueRep.assertEquals(stringArray);
            }
            JBindDatabase jBindDatabase = this.mDB;
            synchronized (jBindDatabase) {
                CacheProcessor.notifySensitiveObjects(hashSet, map, cacheServerSensitive);
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Bad data in cache received from server");
        }
    }

    private int getIdNode(int n, int n2) throws CacheException {
        JBindCacheObject jBindCacheObject = this.mDB.find(n);
        if (jBindCacheObject == null) {
            return -1;
        }
        AbstractCacheClass abstractCacheClass = (AbstractCacheClass)jBindCacheObject.getCacheClass();
        return abstractCacheClass.getOrefSlot(n2);
    }

    private static int checkOrefSlotNode(ZObjectValueRep zObjectValueRep, int n) throws CacheException {
        Dataholder dataholder = zObjectValueRep.getProperty(n);
        if (dataholder == null) {
            return 0;
        }
        if (dataholder.getObject() == null) {
            return 0;
        }
        switch (dataholder.getType()) {
            case 1026: {
                return dataholder.getCacheObject().getOref();
            }
            case 24: 
            case 4096: {
                String string = dataholder.getString();
                int n2 = string.indexOf("@%Collection");
                if (n2 < 0) {
                    return 0;
                }
                try {
                    return JBindDatabase.parseOrefString((String)string).oref;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZObjectValueRep getZobjval(int n, int n2, Object object, boolean bl) throws CacheException {
        JBindDatabase jBindDatabase = this.mDB;
        synchronized (jBindDatabase) {
            ZObjectValueRep zObjectValueRep = null;
            boolean bl2 = this.mDB.isObjectAlive(n);
            if (bl2) {
                JBindCacheObject jBindCacheObject = this.mDB.find(n);
                zObjectValueRep = jBindCacheObject.getZobjval();
                if (zObjectValueRep == null) {
                    zObjectValueRep = CacheProcessor.newZObjVal(n2, object);
                    jBindCacheObject.setZobjval(zObjectValueRep);
                }
            } else {
                zObjectValueRep = CacheProcessor.newZObjVal(n2, object);
            }
            if (!bl2 && bl) {
                this.mTempMap.put(new Integer(n), zObjectValueRep);
            }
            return zObjectValueRep;
        }
    }

    private static ZObjectValueRep newZObjVal(int n, Object object) {
        HashMap hashMap = new HashMap(n);
        return new ZObjectValueRep(hashMap, new Oid(object));
    }

    @Override
    public synchronized void checkIfInTempMap(JBindCacheObject jBindCacheObject) throws CacheException {
        if (this.mTempMap == null) {
            throw new SystemError("Temporary map can not be null");
        }
        int n = jBindCacheObject.getOref();
        ZObjectValueRep zObjectValueRep = (ZObjectValueRep)this.mTempMap.remove(new Integer(n));
        if (zObjectValueRep == null) {
            return;
        }
        jBindCacheObject.setZobjval(zObjectValueRep);
    }

    @Override
    public void clearTempMap() {
        this.mTempMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int processNode(Map map, Object object, PrintWriter printWriter, UnsetProperties unsetProperties, int n) throws SQLException {
        Object object2;
        int n2 = SysListProxy.getInteger(object);
        boolean bl = false;
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        if (printWriter != null) {
            printWriter.print("ii = " + n2);
        }
        if (bl) {
            CacheProcessor.processMDProperty(n2, map, object, printWriter);
            return -n2;
        }
        Object object3 = SysListProxy.getWrappedItem(object);
        if (SysListProxy.isNullOrZero(object3)) {
            bl = true;
        }
        Dataholder dataholder = new Dataholder(4096, object3);
        if (printWriter != null) {
            Object object4 = object2 = object3 == null ? null : object3.toString();
            if (object2 != null) {
                object2 = ((String)object2).substring(4, ((String)object2).length() - 1);
            }
            printWriter.println(": val = " + (String)object2);
            if (object3 != null) {
                SysListProxy.rewind(object3);
            }
        }
        object2 = new Integer(n2);
        Map map2 = map;
        synchronized (map2) {
            if (unsetProperties == null) {
                map.put(object2, dataholder);
            } else {
                UnsetProperties unsetProperties2 = unsetProperties;
                synchronized (unsetProperties2) {
                    if (!unsetProperties.has(n, n2)) {
                        map.put(object2, dataholder);
                    }
                }
            }
        }
        if (bl) {
            return -n2;
        }
        return n2;
    }

    private static void processMDProperty(int n, Map map, Object object, PrintWriter printWriter) throws SQLException {
        byte[] byArray = SysListProxy.getByte(object);
        if (printWriter != null) {
            if (byArray != null) {
                printWriter.println(": val = byte[" + byArray.length + "]");
            } else {
                printWriter.println(": val = null");
            }
        }
    }

    @Override
    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return this.getUnsetProperty(n, n2, n3);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void putData(Object object) throws CacheException {
        this.m_unset_props.makeSetZList(object, this);
    }

    protected static void notifySensitiveObjects(HashSet hashSet, Map map, CacheServerSensitive cacheServerSensitive) throws CacheException {
        if (map == null) {
            return;
        }
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CacheServerSensitive cacheServerSensitive2 = (CacheServerSensitive)entry.getKey();
            if (cacheServerSensitive2.equals(cacheServerSensitive)) continue;
            Set set = (Set)entry.getValue();
            HashSet hashSet2 = null;
            if (set == null) {
                hashSet2 = (HashSet)hashSet.clone();
            } else {
                hashSet2 = new HashSet(set);
                Iterator iterator2 = hashSet2.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Integer n = e instanceof ObjectHandle ? new Integer(((ObjectHandle)e).getOref()) : (Integer)e;
                    if (hashSet.contains(n)) continue;
                    iterator2.remove();
                }
            }
            if (hashSet2.isEmpty() || cacheServerSensitive2.onServerCall(hashSet2)) continue;
            iterator.remove();
        }
    }

    @Override
    public void setProperty(int n, int n2, int n3, String string, Dataholder dataholder) throws CacheException {
        boolean bl = n3 == 1;
        this.m_unset_props.setProperty(n, n2, bl, string, dataholder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dataholder getUnsetProperty(int n, int n2, int n3) throws CacheException {
        boolean bl = n3 == 1;
        UnsetProperties unsetProperties = this.m_unset_props;
        synchronized (unsetProperties) {
            if (this.m_unset_props.find(n, n2, bl)) {
                try {
                    return this.m_unset_props.getProperty(n, n2, bl);
                }
                catch (CacheException cacheException) {
                    return null;
                }
            }
        }
        return null;
    }
}

