/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.CacheObject;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.WeakValuesHashMap;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.runtime.ObjectFactory;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DetachedCacheManager {
    private Collection EMPTY_COLLECTION = new HashSet();
    private boolean mWeakValuesMap;
    private Map mProxyToPojo;
    private Map mPojoToProxy;
    protected Database mDB;
    private PreparedStatement mFindCacheClassNameStatement;
    private Map mJavaCacheClassMap;
    private Set mCleanObjects;
    private int mCacheType;
    private boolean mAssertionsEnabled = false;

    public DetachedCacheManager(Database database) {
        this.mDB = database;
        this.mWeakValuesMap = false;
        this.mCacheType = 0;
        this.mCleanObjects = new HashSet();
    }

    public void setCacheType(int n) {
        if (this.mCacheType < 0) {
            throw new IllegalStateException("Can not change Client Cache Type. Caches are already initialized.");
        }
        this.mCacheType = n;
    }

    public void enableAsertions(boolean bl) {
        this.mAssertionsEnabled = bl;
    }

    public int getCacheType() {
        if (this.mCacheType < 0) {
            if (this.mWeakValuesMap) {
                return 16;
            }
            return 32;
        }
        return this.mCacheType;
    }

    public synchronized Object findPOJO(CacheRootObject cacheRootObject, boolean bl) throws CacheException {
        if (this.mProxyToPojo == null) {
            return null;
        }
        if (!(cacheRootObject instanceof Persistent)) {
            return null;
        }
        Persistent persistent = (Persistent)cacheRootObject;
        Oid oid = persistent.getOid();
        return this.findPOJO(oid, bl);
    }

    public synchronized Object findPOJO(Oid oid, boolean bl) {
        if (this.mProxyToPojo == null) {
            return null;
        }
        Object v = this.mProxyToPojo.get(oid);
        if (bl) {
            return v;
        }
        if (v == null || ObjectFactory.isProxy(v)) {
            return null;
        }
        return v;
    }

    public Collection currentCache() {
        if (this.mPojoToProxy == null) {
            return this.EMPTY_COLLECTION;
        }
        return new HashSet(this.mPojoToProxy.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Persistent findProxyInMemory(Object object) throws CacheException {
        if (this.mPojoToProxy == null) {
            return null;
        }
        Oid oid = (Oid)this.mPojoToProxy.get(object);
        if (oid == null) {
            return null;
        }
        Database database = this.mDB;
        synchronized (database) {
            return (Persistent)Persistent._open(this.mDB, oid, true);
        }
    }

    public synchronized Oid findOidInMemory(Object object) throws CacheException {
        if (this.mPojoToProxy == null) {
            return null;
        }
        Oid oid = (Oid)this.mPojoToProxy.get(object);
        return oid;
    }

    public synchronized Id findIdInMemory(Object object) throws CacheException {
        if (this.mPojoToProxy == null) {
            return null;
        }
        Oid oid = (Oid)this.mPojoToProxy.get(object);
        if (oid == null) {
            return null;
        }
        return oid.getId();
    }

    public synchronized void register(Persistent persistent, Object object) throws CacheException {
        if (this.mProxyToPojo == null) {
            this.initMaps();
        }
        if (!this.mAssertionsEnabled && this.mPojoToProxy.containsKey(object)) {
            persistent.getProxy().setStateReadDirty();
            return;
        }
        Oid oid = persistent.getOid();
        if (oid == null || oid.undefined()) {
            try {
                persistent.save();
            }
            catch (CacheException cacheException) {
                persistent.getProxy().saveRequiredFields();
            }
            oid = persistent.getOid();
        }
        if (this.mAssertionsEnabled) {
            Object v = this.mPojoToProxy.get(object);
            if (v != null && !v.equals(oid)) {
                throw new IllegalArgumentException("Remapping!");
            }
            Object v2 = this.mProxyToPojo.get(oid);
            if (v2 != null && !v2.equals(object)) {
                throw new IllegalArgumentException("Remapping!");
            }
        }
        this.mPojoToProxy.put(object, oid);
        this.mProxyToPojo.put(oid, object);
        persistent.getProxy().setStateReadDirty();
    }

    public synchronized void register(CacheObject cacheObject, Object object) throws CacheException {
        if (this.mProxyToPojo == null) {
            this.initMaps();
        }
        if (!this.mAssertionsEnabled && this.mPojoToProxy.containsKey(object)) {
            cacheObject.setStateReadDirty();
            return;
        }
        Oid oid = cacheObject.getOid();
        if (oid == null || oid.undefined()) {
            return;
        }
        if (this.mAssertionsEnabled) {
            Object v = this.mPojoToProxy.get(object);
            if (v != null && !v.equals(oid)) {
                throw new IllegalArgumentException("Remapping!");
            }
            Object v2 = this.mProxyToPojo.get(oid);
            if (v2 != null && !v2.equals(object)) {
                throw new IllegalArgumentException("Remapping!");
            }
        }
        this.mPojoToProxy.put(object, oid);
        this.mProxyToPojo.put(oid, object);
        cacheObject.setStateReadDirty();
    }

    public synchronized void register(Oid oid, Object object) throws CacheException {
        if (this.mProxyToPojo == null) {
            this.initMaps();
        }
        if (!this.mAssertionsEnabled && this.mPojoToProxy.containsKey(object)) {
            return;
        }
        if (oid == null || oid.undefined()) {
            return;
        }
        if (this.mAssertionsEnabled) {
            Object v = this.mPojoToProxy.get(object);
            if (v != null && !v.equals(oid)) {
                throw new IllegalArgumentException("Remapping!");
            }
            Object v2 = this.mProxyToPojo.get(oid);
            if (v2 != null && !v2.equals(object)) {
                throw new IllegalArgumentException("Remapping!");
            }
        }
        this.mPojoToProxy.put(object, oid);
        this.mProxyToPojo.put(oid, object);
    }

    public CacheClass findCacheClassForPOJO(String string) throws CacheException, SQLException, ClassNotFoundException {
        String string2 = null;
        try {
            string2 = this.findCacheClassNameForPOJO(string);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 99) {
                throw new SQLException("Can not determine Cache class that corresponds to Java class " + string + ". Insufficient privillege to query Class Dictionary. " + "Please grant SELECT on %Dictionary.ClassDefinition", sQLException.getSQLState(), sQLException.getErrorCode());
            }
            throw sQLException;
        }
        if (string2 != null) {
            return this.mDB.getCacheClass(string2);
        }
        throw new ClassNotFoundException("No Cache class found that corresponds to Java class " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String findCacheClassNameForPOJO(String string) throws CacheException, SQLException, ClassNotFoundException {
        String string2;
        if (this.mFindCacheClassNameStatement == null) {
            this.initFind();
        }
        if ((string2 = this.getCacheClassNameFromMap(string)) != null) {
            return string2;
        }
        this.mFindCacheClassNameStatement.setString(1, string);
        this.mFindCacheClassNameStatement.setString(2, string);
        ResultSet resultSet = this.mFindCacheClassNameStatement.executeQuery();
        try {
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
                if (resultSet.next()) {
                    DetachedCacheManager.reportMultiProjectionError(resultSet, string2, string);
                }
                this.putCacheClassNameIntoMap(string, string2);
                String string3 = string2;
                return string3;
            }
        }
        finally {
            resultSet.close();
        }
        throw new ClassNotFoundException("No Cache class found that corresponds to Java class " + string);
    }

    private static void reportMultiProjectionError(ResultSet resultSet, String string, String string2) throws SQLException {
        do {
            string = string + ", " + resultSet.getString(1);
        } while (resultSet.next());
        throw new IllegalStateException("More than one Cache Class correponds to Java Class " + string2 + ". Those classes are: " + string);
    }

    protected String getCacheClassNameFromMap(String string) {
        if (this.mJavaCacheClassMap == null) {
            this.mJavaCacheClassMap = new HashMap();
        }
        String string2 = (String)this.mJavaCacheClassMap.get(string);
        return string2;
    }

    protected void putCacheClassNameIntoMap(String string, String string2) {
        this.mJavaCacheClassMap.put(string, string2);
    }

    private void initFind() throws CacheException {
        String string = ((SysDatabase)this.mDB).getCacheClassForJavaClassSQL();
        this.mFindCacheClassNameStatement = this.mDB.prepareStatement(string);
        if (this.mJavaCacheClassMap == null) {
            this.mJavaCacheClassMap = new HashMap();
        }
    }

    public synchronized Object purge(Object object) throws SystemError {
        if (object instanceof Iterator) {
            try {
                if (LightDatabase.closeStatement((Iterator)object)) {
                    return null;
                }
            }
            catch (SQLException sQLException) {
                if (Logger.debugOn()) {
                    sQLException.printStackTrace();
                }
                throw new SystemError(sQLException, "Error closing Iterator");
            }
        }
        if (this.mPojoToProxy == null) {
            return null;
        }
        Object v = this.mPojoToProxy.get(object);
        if (v != null) {
            Object v2 = this.mProxyToPojo.get(v);
            if (!object.equals(v2)) {
                throw new SystemError("Inconsistency in Maps");
            }
            this.mPojoToProxy.remove(object);
            this.mProxyToPojo.remove(v);
            try {
                this.mDB.releaseObject(v);
            }
            catch (CacheException cacheException) {
                throw new SystemError(cacheException, "Failed to close object");
            }
        }
        return v;
    }

    public void setDirty(Object object) throws CacheException {
        if (ObjectFactory.isProxy(object)) {
            ObjectFactory.unswizzle(object);
        }
        if (this.mPojoToProxy == null) {
            return;
        }
        Oid oid = (Oid)this.mPojoToProxy.get(object);
        if (oid == null) {
            return;
        }
        ((SysDatabase)this.mDB).setCacheObjectReadDirty(oid);
    }

    public void saveCleanState(Oid oid) {
        if (this.mProxyToPojo.containsKey(oid)) {
            this.mCleanObjects.add(oid);
        }
    }

    public boolean isCleanState(Oid oid) {
        boolean bl = this.mCleanObjects.remove(oid);
        return bl;
    }

    public synchronized void purge(Object object, Persistent persistent) throws CacheException {
        if (this.mPojoToProxy == null) {
            return;
        }
        Oid oid = persistent.getOid();
        this.mPojoToProxy.remove(object);
        this.mProxyToPojo.remove(oid);
        persistent.release();
    }

    public int getMemoryCacheSize(int n) {
        int n2 = this.mPojoToProxy == null ? 0 : this.mPojoToProxy.size();
        int n3 = this.mProxyToPojo == null ? 0 : this.mProxyToPojo.size();
        switch (n) {
            case 1: {
                return n2;
            }
            case 2: {
                return n3;
            }
            case 3: {
                return this.mDB.getNumberOfOpenObjects();
            }
        }
        return n2;
    }

    public synchronized void clear() {
        block6: {
            if (this.mProxyToPojo != null) {
                this.mProxyToPojo.clear();
            }
            if (this.mPojoToProxy != null) {
                this.mPojoToProxy.clear();
            }
            if (this.mJavaCacheClassMap != null) {
                this.mJavaCacheClassMap.clear();
            }
            try {
                if (this.mFindCacheClassNameStatement != null) {
                    this.mFindCacheClassNameStatement.close();
                }
            }
            catch (SQLException sQLException) {
                if (!Logger.debugOn()) break block6;
                sQLException.printStackTrace(Logger.out);
            }
        }
        this.mFindCacheClassNameStatement = null;
    }

    public synchronized void removeClass(String string) {
        this.mJavaCacheClassMap.remove(string);
    }

    public void close() {
        if (this.mWeakValuesMap) {
            this.mProxyToPojo.put(WeakValuesHashMap.TERMINATE, null);
        }
    }

    protected void reportWeakStatistics(PrintStream printStream) {
        if (this.mWeakValuesMap) {
            this.mProxyToPojo.put(WeakValuesHashMap.REPORT, printStream);
        }
    }

    protected boolean isProfileOn() {
        return false;
    }

    private void initMaps() {
        boolean bl;
        if (this.mCacheType == 16) {
            bl = true;
        } else if (this.mCacheType == 32) {
            bl = false;
        } else {
            String string = System.getProperty("com.intersys.cache.jalapeno");
            bl = false;
            if (string != null) {
                if (string.equalsIgnoreCase("strong")) {
                    bl = false;
                } else if (string.equalsIgnoreCase("weak")) {
                    bl = true;
                } else {
                    throw new IllegalArgumentException("Unkown POJO Cache Type: " + string + ". Allowed values: " + "\"weak\" or \"strong\".");
                }
            }
        }
        if (bl) {
            this.mPojoToProxy = new WeakHashMap();
            this.mProxyToPojo = WeakValuesHashMap.create(this.isProfileOn());
            this.mWeakValuesMap = true;
        } else {
            this.mPojoToProxy = new HashMap();
            this.mProxyToPojo = new HashMap();
        }
    }
}

