/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.EJB.objects;

import com.intersys.EJB.objects.SerializableReader;
import java.io.IOException;
import java.io.Reader;

public class EJBCharacterStream
extends SerializableReader {
    char[] buf;
    int offset;
    int length;
    public static final int bufsize = 2048;

    public EJBCharacterStream(Reader reader) throws IOException {
        int n;
        this.buf = new char[2048];
        int n2 = 2048;
        this.offset = 0;
        if (reader == null) {
            this.offset = 0;
            this.length = 0;
            return;
        }
        while ((n = reader.read(this.buf, this.offset, n2)) != -1) {
            this.length += n;
            if ((n2 -= n) == 0) {
                char[] cArray = new char[this.buf.length + 2048];
                System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                this.buf = cArray;
                n2 = 2048;
            }
            this.offset += n;
        }
        this.offset = 0;
    }

    public EJBCharacterStream(char[] cArray, int n) {
        this.buf = cArray;
        this.offset = 0;
        this.length = n;
    }

    public EJBCharacterStream(char[] cArray) {
        this.buf = cArray;
        this.offset = 0;
        this.length = cArray.length;
    }

    public EJBCharacterStream(char[] cArray, int n, int n2) {
        this.buf = cArray;
        this.offset = n;
        this.length = n2;
    }

    public void rewind() {
        this.offset = 0;
    }

    public int available() throws IOException {
        return this.length - this.offset;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        int n3 = n2 <= this.available() ? n2 : this.available();
        System.arraycopy(this.buf, this.offset, cArray, n, n3);
        this.offset += n3;
        return n3;
    }

    @Override
    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return cArray[0];
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public void close() {
    }
}

