/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.dialogs.ComplexObjectEditor;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class ComplexValueInlineEditor
extends BaseValueEditor<Tree> {
    private final IValueController controller;
    protected ComplexObjectEditor editor;

    public ComplexValueInlineEditor(IValueController controller) {
        super(controller);
        this.controller = controller;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        this.editor.setModel(this.controller.getExecutionContext(), value);
    }

    @Override
    protected Tree createControl(Composite editPlaceholder) {
        boolean inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        this.editor = new ComplexObjectEditor(this.controller, this, inline ? 0 : 2048);
        this.editor.setModel(this.controller.getExecutionContext(), this.controller.getValue());
        return this.editor.getTree();
    }

    @Override
    public Object extractEditorValue() {
        return this.editor.extractValue();
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
        this.editor.contributeActions(manager);
    }
}

