/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import com.dbeaver.db.ycql.data.CasAbstractValue;
import com.dbeaver.db.ycql.data.CasListValue;
import com.dbeaver.db.ycql.data.CasMapValue;
import com.dbeaver.db.ycql.data.CasSetValue;
import com.dbeaver.db.ycql.exec.CasResultSet;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasKeyspace;
import com.dbeaver.db.ycql.model.CasUserType;
import com.dbeaver.db.ycql.model.CasUserTypeAttribute;
import com.dbeaver.ee.model.content.DBContentByteBuffer;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CasUDTValue
extends CasAbstractValue
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasUDTValue.class);
    @Nullable
    private UDTValue rawValue;
    @Nullable
    private CasUserType userType;

    public CasUDTValue(@NotNull CasExecutionContext executionContext, @NotNull String keyspace, @Nullable UDTValue value) throws DBCException {
        super(executionContext, keyspace);
        this.rawValue = value;
        if (value == null) {
            this.userType = null;
        } else {
            String keyspaceName = value.getType().getKeyspace();
            CasKeyspace ks = ((CasDataSource)executionContext.getDataSource()).getKeyspace(keyspaceName);
            if (ks == null) {
                throw new DBCException("UDT keyspace '" + keyspaceName + "' not found");
            }
            try {
                this.userType = ks.getUserType((DBRProgressMonitor)new VoidProgressMonitor(), (DataType)value.getType());
            }
            catch (DBException e) {
                throw new DBCException("Error reading user type for UDT", (Throwable)e);
            }
            if (this.userType == null) {
                throw new DBCException("Can't find user type for UDT value: " + value.getType());
            }
        }
    }

    public CasUDTValue(CasUDTValue value) {
        super(value);
        this.rawValue = value.rawValue;
        this.userType = value.userType;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new CasUDTValue(this);
    }

    public UDTValue getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.rawValue = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.rawValue.toString();
    }

    public CasUserType getDataType() {
        return this.userType;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.userType == null) {
            return new DBSAttributeBase[0];
        }
        try {
            List<CasUserTypeAttribute> attrs = this.userType.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            if (attrs == null) {
                return new DBSAttributeBase[0];
            }
            DBSAttributeBase[] result = new DBSAttributeBase[attrs.size()];
            attrs.toArray(result);
            return result;
        }
        catch (DBException e) {
            log.error((Object)e);
            return new DBSAttributeBase[0];
        }
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        if (this.rawValue == null) {
            return null;
        }
        int index = attribute.getOrdinalPosition() - 1;
        DataType type = ((CasUserTypeAttribute)attribute).getCasDataType();
        switch (type.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.rawValue.getString(index);
            }
            case TINYINT: {
                return this.rawValue.getByte(index);
            }
            case SMALLINT: {
                return this.rawValue.getShort(index);
            }
            case INT: {
                return this.rawValue.getInt(index);
            }
            case BIGINT: {
                return this.rawValue.getLong(index);
            }
            case COUNTER: {
                return this.rawValue.getLong(index);
            }
            case VARINT: {
                return this.rawValue.getVarint(index);
            }
            case DECIMAL: {
                return this.rawValue.getDecimal(index);
            }
            case FLOAT: {
                return Float.valueOf(this.rawValue.getFloat(index));
            }
            case DOUBLE: {
                return this.rawValue.getDouble(index);
            }
            case BOOLEAN: {
                return this.rawValue.getBool(index);
            }
            case DATE: {
                return this.rawValue.getDate(index);
            }
            case TIME: {
                return this.rawValue.getTime(index);
            }
            case TIMESTAMP: {
                return this.rawValue.getTimestamp(index);
            }
            case UUID: 
            case TIMEUUID: {
                return this.rawValue.getUUID(index);
            }
            case INET: {
                return this.rawValue.getInet(index);
            }
            case MAP: {
                return new CasMapValue(this.executionContext, this.keyspace, this.rawValue.getMap(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(1))), type);
            }
            case LIST: {
                return new CasListValue((DBRProgressMonitor)new VoidProgressMonitor(), this.executionContext, this.keyspace, this.rawValue.getList(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0))), type);
            }
            case SET: {
                return new CasSetValue(this.executionContext, this.keyspace, this.rawValue.getSet(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0))), type);
            }
            case TUPLE: {
                return this.rawValue.getTupleValue(index);
            }
            case UDT: {
                return new CasUDTValue(this.executionContext, this.keyspace, this.rawValue.getUDTValue(index));
            }
        }
        return new DBContentByteBuffer((DBCExecutionContext)this.executionContext, this.rawValue.getBytes(index));
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) throws DBCException {
        log.error((Object)"UDT value set not implemented yet");
    }
}

