/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.MongoConstants;
import com.dbeaver.ee.model.NoSQLDialect;
import java.util.Arrays;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.sql.RelationalSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;

public class MGSQLDialect
extends NoSQLDialect
implements RelationalSQLDialect {
    public static final MGSQLDialect INSTANCE = new MGSQLDialect();

    public MGSQLDialect() {
        this.addKeywords(Arrays.asList(MongoConstants.JS_KEYWORDS), DBPKeywordType.KEYWORD);
        this.addFunctions(Arrays.asList(MongoConstants.SQL_FUNCTIONS));
        Collections.addAll(this.types, MongoConstants.JS_TYPES);
    }

    @NotNull
    public String getDialectId() {
        return "mongodb";
    }

    @NotNull
    public String getDialectName() {
        return "Mongo";
    }

    public String[][] getIdentifierQuoteStrings() {
        return new String[][]{{"\"", "\""}};
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean isStandardSQL() {
        return false;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean isAmbiguousCountBroken() {
        return false;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> String.valueOf(left) + " ILIKE " + right;
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }
}

