/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.model.MGDataSource;
import com.mongodb.MongoClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class MGDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(MGDataSourceInfo.class);
    private final MGDataSource dataSource;
    private final MongoClient client;
    private Map<String, Object> databaseVersion;

    public MGDataSourceInfo(MGDataSource dataSource, MongoClient client) {
        this.dataSource = dataSource;
        this.client = client;
    }

    public boolean isReadOnlyData() {
        return false;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return this.dataSource.getDatabaseType();
    }

    public String getDatabaseProductVersion() {
        Map<String, Object> productDetails = this.getDatabaseProductDetails();
        return CommonUtils.toString((Object)productDetails.get("version"));
    }

    @NotNull
    public Map<String, Object> getDatabaseProductDetails() {
        if (this.databaseVersion == null) {
            try {
                this.databaseVersion = this.client.getDatabase("local").runCommand((Bson)new Document("buildInfo", (Object)1));
            }
            catch (Exception e) {
                log.warn((Object)"Error getting build info", (Throwable)e);
            }
            if (this.databaseVersion == null) {
                this.databaseVersion = new HashMap<String, Object>();
            }
        }
        return this.databaseVersion;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public Version getDatabaseVersion() {
        return new Version(this.getDatabaseProductVersion());
    }

    public String getDriverName() {
        return "mongo-java-driver";
    }

    public String getDriverVersion() {
        return "3.12.7";
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)"org.mongodb.mongo-java-driver");
        if (bundle == null) {
            throw new IllegalStateException("Mongo driver bundle 'org.mongodb.mongo-java-driver' not found");
        }
        return bundle;
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return true;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean isDynamicMetadata() {
        return true;
    }
}

