/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.bson.BsonRegularExpression;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class MongoSQLUtils {
    public static final String OPER_NE = "$ne";
    public static final String OPER_GT = "$gt";
    public static final String OPER_GTE = "$gte";
    public static final String OPER_LT = "$lt";
    public static final String OPER_LTE = "$lte";
    public static final String OPER_REGEX = "$regex";
    public static final String OPER_IN = "$in";
    public static final String OPER_NOT = "$not";
    public static final String OPER_EXISTS = "$exists";
    public static final String OPER_AND = "$and";
    public static final String OPER_OR = "$or";
    private static final Log log = Log.getLog(MongoSQLUtils.class);

    public static DBObject normalizeMongoValue(MGDataSource dataSource, DBObject o) {
        if (o instanceof Map) {
            MongoSQLUtils.normalizeDocument(dataSource, (Map)o);
        } else if (o instanceof List) {
            MongoSQLUtils.normalizeDocument(dataSource, (List)o);
        }
        return o;
    }

    public static void normalizeDocument(MGDataSource dataSource, Map<String, Object> o) {
        for (Map.Entry<String, Object> entry : o.entrySet()) {
            if (!(entry.getValue() instanceof Decimal128) || dataSource.supportsDecimal128()) continue;
            entry.setValue(((Decimal128)entry.getValue()).doubleValue());
        }
    }

    public static void normalizeDocument(MGDataSource dataSource, List<Object> o) {
        for (Object item : o) {
            if (!(item instanceof DBObject)) continue;
            MongoSQLUtils.normalizeMongoValue(dataSource, (DBObject)item);
        }
    }

    @Nullable
    public static DBObject makeQueryFromFilter(@NotNull MGDataSource dataSource, @Nullable DBDDataFilter filter) throws DBCException {
        if (filter == null || !filter.hasConditions()) {
            return null;
        }
        StringBuilder condString = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)condString, (boolean)true);
        try {
            Expression expr = CCJSqlParserUtil.parseCondExpression((String)condString.toString());
            return MongoSQLUtils.convertExpressionToObject(expr);
        }
        catch (JSQLParserException e) {
            throw new DBCException("Bad filter conditions", (Throwable)e);
        }
    }

    @NotNull
    public static String makeSQLQuery(@NotNull MGCollection collection, @Nullable DBDDataFilter filter) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (filter != null && filter.hasConditions()) {
            sql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            sql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql);
        }
        return sql.toString();
    }

    public static DBObject convertExpressionToObject(Expression expression) throws DBCException {
        BasicDBObject object = new BasicDBObject();
        MongoSQLUtils.parseExpression(object, expression);
        return object;
    }

    private static void parseExpression(BasicDBObject owner, Expression expr) throws DBCException {
        if (expr instanceof AndExpression) {
            BasicDBList list = new BasicDBList();
            list.add((Object)MongoSQLUtils.convertExpressionToObject(((AndExpression)expr).getLeftExpression()));
            list.add((Object)MongoSQLUtils.convertExpressionToObject(((AndExpression)expr).getRightExpression()));
            owner.put((Object)OPER_AND, (Object)list);
        } else if (expr instanceof OrExpression) {
            BasicDBList list = new BasicDBList();
            list.add((Object)MongoSQLUtils.convertExpressionToObject(((OrExpression)expr).getLeftExpression()));
            list.add((Object)MongoSQLUtils.convertExpressionToObject(((OrExpression)expr).getRightExpression()));
            owner.put((Object)OPER_OR, (Object)list);
        } else if (expr instanceof InExpression) {
            Expression leftExpression = ((InExpression)expr).getLeftExpression();
            if (!(leftExpression instanceof Column)) {
                throw new DBCException("IN conditions mast have column on the left side");
            }
            if (!(((InExpression)expr).getRightItemsList() instanceof ExpressionList)) {
                throw new DBCException("IN conditions mast have expression list on the right side");
            }
            ExpressionList itemsList = (ExpressionList)((InExpression)expr).getRightItemsList();
            Column column = (Column)leftExpression;
            String fieldName = MongoSQLUtils.unquote(column.getFullyQualifiedName());
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression exp : itemsList.getExpressions()) {
                Object fieldValue = MongoSQLUtils.parseValueExpression(exp);
                values.add(fieldValue);
            }
            MongoSQLUtils.makeObjectCondition(owner, fieldName, values, OPER_IN);
        } else if (expr instanceof Between) {
            Expression left = ((Between)expr).getLeftExpression();
            if (!(left instanceof Column)) {
                throw new DBCException("Unsupported left operand: " + left);
            }
            String columnName = MongoSQLUtils.unquote(((Column)left).getFullyQualifiedName());
            BasicDBObject columnRange = new BasicDBObject();
            columnRange.put((Object)OPER_GTE, MongoSQLUtils.parseValueExpression(((Between)expr).getBetweenExpressionStart()));
            columnRange.put((Object)OPER_LTE, MongoSQLUtils.parseValueExpression(((Between)expr).getBetweenExpressionEnd()));
            owner.put((Object)columnName, (Object)columnRange);
        } else if (expr instanceof BinaryExpression) {
            MongoSQLUtils.parseBinaryExpression(owner, (BinaryExpression)expr);
        } else if (expr instanceof Parenthesis) {
            MongoSQLUtils.parseExpression(owner, ((Parenthesis)expr).getExpression());
        } else {
            throw new DBCException("Unsupported expression: " + expr);
        }
    }

    private static void parseBinaryExpression(BasicDBObject owner, BinaryExpression expr) throws DBCException {
        String operator;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + left);
        }
        Column column = (Column)left;
        String fieldName = MongoSQLUtils.unquote(column.getFullyQualifiedName());
        Object fieldValue = MongoSQLUtils.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            operator = null;
        } else if (expr instanceof NotEqualsTo) {
            operator = OPER_NE;
        } else if (expr instanceof GreaterThan) {
            operator = OPER_GT;
        } else if (expr instanceof GreaterThanEquals) {
            operator = OPER_GTE;
        } else if (expr instanceof MinorThan) {
            operator = OPER_LT;
        } else if (expr instanceof MinorThanEquals) {
            operator = OPER_LTE;
        } else if (expr instanceof LikeExpression) {
            LikeExpression like = (LikeExpression)expr;
            operator = like.isNot() ? OPER_NOT : OPER_REGEX;
            fieldValue = MongoSQLUtils.makeRegexFromLike((String)fieldValue, like.isCaseInsensitive() ? "i" : null);
        } else {
            throw new DBCException("Unsupported operation: " + expr.getStringExpression());
        }
        MongoSQLUtils.makeObjectCondition(owner, fieldName, fieldValue, operator);
    }

    private static void makeObjectCondition(BasicDBObject owner, String fieldName, Object fieldValue, String operator) {
        Object value;
        if (fieldName.equals("_id") && fieldValue instanceof String) {
            try {
                fieldValue = new ObjectId((String)fieldValue);
            }
            catch (Exception exception) {}
        }
        if (operator == null) {
            value = fieldValue;
        } else if (fieldValue instanceof List) {
            BasicDBList dbList = new BasicDBList();
            dbList.addAll((Collection)((List)fieldValue));
            value = new BasicDBObject(operator, (Object)dbList);
        } else {
            value = new BasicDBObject(operator, fieldValue);
            if (operator.equals(OPER_NE) || operator.equals(OPER_NOT)) {
                ((DBObject)value).put(OPER_EXISTS, (Object)true);
            }
        }
        owner.put((Object)fieldName, value);
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = MongoSQLUtils.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + expr);
        }
        if (expr instanceof Function) {
            String funcName = ((Function)expr).getName();
            ExpressionList parameters = ((Function)expr).getParameters();
            if ("ObjectId".equalsIgnoreCase(funcName)) {
                if (parameters == null || parameters.getExpressions().size() != 1) {
                    throw new DBCException("ObjectId must have 1 parameter");
                }
                return new ObjectId(CommonUtils.toString((Object)MongoSQLUtils.parseValueExpression((Expression)parameters.getExpressions().get(0))));
            }
            if ("ISODate".equalsIgnoreCase(funcName)) {
                if (parameters == null || parameters.getExpressions().size() != 1) {
                    throw new DBCException("ISODate must have 1 parameter");
                }
                return JSONUtils.parseDate((Object)MongoSQLUtils.parseValueExpression((Expression)parameters.getExpressions().get(0)));
            }
            throw new DBCException("Unsupported function: " + funcName);
        }
        if (expr instanceof SignedExpression) {
            Object value = MongoSQLUtils.parseValueExpression(((SignedExpression)expr).getExpression());
            char sign = ((SignedExpression)expr).getSign();
            if (value instanceof Long) {
                if (sign == '-') {
                    return -((Long)value).longValue();
                }
                if (sign == '+') {
                    return value;
                }
            } else if (value instanceof Double) {
                if (sign == '-') {
                    return -((Double)value).doubleValue();
                }
                if (sign == '+') {
                    return value;
                }
            }
        }
        throw new DBCException("Unsupported value: " + expr);
    }

    private static BsonRegularExpression makeRegexFromLike(String clause, String options) {
        return new BsonRegularExpression(SQLUtils.makeRegexFromLike((String)clause), options);
    }

    public static String unquote(String name) {
        CharSequence[] attrNameParts = SQLUtils.splitFullIdentifier((String)name, (String)".", (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS, (boolean)false);
        return String.join((CharSequence)".", attrNameParts);
    }

    public static Object convertValueExpressionToObject(Expression expression) throws DBCException {
        if (expression instanceof StringValue) {
            return ((StringValue)expression).getValue();
        }
        if (expression instanceof LongValue) {
            return ((LongValue)expression).getValue();
        }
        if (expression instanceof DoubleValue) {
            return ((DoubleValue)expression).getValue();
        }
        if (expression instanceof DateValue) {
            return ((DateValue)expression).getValue();
        }
        if (expression instanceof TimestampValue) {
            return ((TimestampValue)expression).getValue();
        }
        return expression.toString();
    }
}

