/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaList;
import org.mozilla.javascript.NativeJavaMap;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class MongoJSUtils {
    private static final Log log = Log.getLog(MongoJSUtils.class);

    public static List<? extends Document> createDocumentList(List<Map<String, Object>> documents) {
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map<String, Object> item : documents) {
            result.add(new Document(MongoJSUtils.unwrapMap(item)));
        }
        return result;
    }

    public static List<DBObject> createBasicList(List<Map<String, Object>> documents) {
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        for (Map<String, Object> item : documents) {
            result.add((DBObject)new BasicDBObject(MongoJSUtils.unwrapMap(item)));
        }
        return result;
    }

    @NotNull
    public static Map<String, Object> unwrapMap(@NotNull Map<String, Object> map) {
        HashMap<String, Object> uMap = new HashMap<String, Object>(map);
        for (Map.Entry entry : uMap.entrySet()) {
            Object value = MongoJSUtils.unwrapObject(entry.getValue());
            entry.setValue(value);
        }
        return uMap;
    }

    @NotNull
    static BasicDBObject createBasicDocument(Map<String, Object> document) {
        return new BasicDBObject(MongoJSUtils.unwrapMap(document));
    }

    @NotNull
    static Document createDocument(Map<String, Object> document) {
        return new Document(MongoJSUtils.unwrapMap(document));
    }

    public static Object unwrapObject(Object obj) {
        block23: {
            if (obj instanceof Map) {
                return MongoJSUtils.unwrapMap((Map)obj);
            }
            if (!(obj instanceof Scriptable)) break block23;
            Object value = null;
            Scriptable so = (Scriptable)obj;
            switch (so.getClassName()) {
                case "Date": {
                    value = new Date((long)ScriptRuntime.toNumber((Object)so));
                    break;
                }
                case "Array": {
                    NativeArray list = (NativeArray)so;
                    BasicDBList uList = new BasicDBList();
                    for (Object item : list) {
                        uList.add(MongoJSUtils.unwrapObject(item));
                    }
                    value = uList;
                    break;
                }
                case "JavaObject": {
                    value = ((NativeJavaObject)so).unwrap();
                    break;
                }
                case "JavaMap": {
                    value = MongoJSUtils.unwrapMap((Map)((NativeJavaMap)so).unwrap());
                    break;
                }
                case "JavaList": {
                    List list = (List)((NativeJavaList)so).unwrap();
                    BasicDBList uList = new BasicDBList();
                    for (Object item : list) {
                        uList.add(MongoJSUtils.unwrapObject(item));
                    }
                    value = uList;
                }
            }
            if (value == null) {
                log.debug((Object)("WARNING: Cannot unwrap JS object " + so.getClassName() + " [" + so.toString() + "]. Convert to null."));
            }
            return value;
        }
        return obj;
    }

    public static ObjectId createObjectId(String str) {
        return new ObjectId(str);
    }
}

