/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.exec.js.MongoJSUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;

public class MongoJSCollection
extends AbstractMap<String, Object> {
    private static final Log log = Log.getLog(MongoJSCollection.class);
    private final MongoJSDatabase database;
    private final MGCollection collection;

    public MongoJSCollection(MongoJSDatabase database, MGCollection collection) {
        this.database = database;
        this.collection = collection;
    }

    @Nullable
    private ClientSession getClientSession() {
        return this.getMongoSession().getClientSession();
    }

    @NotNull
    private MongoSession getMongoSession() {
        return this.database.getProcessor().getSession();
    }

    @Override
    public Object get(Object key) {
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return ((Object)((Object)this.collection)).hashCode();
    }

    @Deprecated
    @NotNull
    private DBCollection getDBCollection() throws DBCException {
        return this.collection.getCollection(this.getMongoSession());
    }

    @NotNull
    private MongoCollection<Document> getMongoCollection() throws DBCException {
        return this.collection.getMongoCollection(this.getMongoSession());
    }

    public Object insert(Map<String, Object> document) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getDBCollection().insert(new DBObject[]{MongoJSUtils.createBasicDocument(MongoJSUtils.unwrapMap(document))});
        }
        this.getMongoCollection().insertOne(clientSession, (Object)MongoJSUtils.createDocument(document));
        return "Inserted 1 document";
    }

    public Object insert(List<Map<String, Object>> documents) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getDBCollection().insert(MongoJSUtils.createBasicList(documents));
        }
        this.getMongoCollection().insertMany(clientSession, MongoJSUtils.createDocumentList(documents));
        return "Inserted " + documents.size() + " document(s)";
    }

    public Object save(Map<String, Object> document) throws DBCException {
        return this.getDBCollection().save((DBObject)MongoJSUtils.createBasicDocument(document));
    }

    public Object update(Map<String, Object> query, Map<String, Object> update, boolean upsert, boolean multi) throws DBCException {
        return this.getDBCollection().update((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(update), upsert, multi);
    }

    public WriteResult update(Map<String, Object> query, Map<String, Object> update) throws DBCException {
        return this.getDBCollection().update((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(update));
    }

    public WriteResult remove(Map<String, Object> query) throws DBCException {
        return this.getDBCollection().remove((DBObject)MongoJSUtils.createBasicDocument(query));
    }

    @Deprecated
    public DBCursor find(Map<String, Object> query, Map<String, Object> projection, int numToSkip, int batchSize, int options) throws DBCException {
        return this.getDBCollection().find((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(projection), numToSkip, batchSize, options);
    }

    @Deprecated
    public DBCursor find(Map<String, Object> query, Map<String, Object> projection, int numToSkip, int batchSize) throws DBCException {
        return this.getDBCollection().find((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(projection), numToSkip, batchSize);
    }

    public DBCursor find(Map<String, Object> query) throws DBCException {
        return this.getDBCollection().find((DBObject)MongoJSUtils.createBasicDocument(query));
    }

    public DBCursor find(Map<String, Object> query, Map<String, Object> projection) throws DBCException {
        return this.getDBCollection().find((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(projection));
    }

    public Iterable<DBObject> aggregate(List<Map<String, Object>> documents) throws DBCException {
        ClientSession clientSession = this.getClientSession();
        if (clientSession == null) {
            return this.getDBCollection().aggregate(MongoJSUtils.createBasicList(documents)).results();
        }
        return this.getMongoCollection().aggregate(clientSession, MongoJSUtils.createDocumentList(documents)).map(BasicDBObject::new);
    }

    public DBCursor find() throws DBCException {
        return this.getDBCollection().find();
    }

    @Nullable
    public DBObject findOne() throws DBCException {
        return this.getDBCollection().findOne();
    }

    @Nullable
    public DBObject findOne(Map<String, Object> query) throws DBCException {
        return this.getDBCollection().findOne((DBObject)MongoJSUtils.createBasicDocument(query));
    }

    @Nullable
    public DBObject findOne(Map<String, Object> query, Map<String, Object> projection) throws DBCException {
        return this.getDBCollection().findOne((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(projection));
    }

    @Nullable
    public DBObject findOne(Map<String, Object> query, Map<String, Object> projection, Map<String, Object> sort) throws DBCException {
        return this.getDBCollection().findOne((DBObject)MongoJSUtils.createBasicDocument(query), (DBObject)MongoJSUtils.createBasicDocument(projection), (DBObject)MongoJSUtils.createBasicDocument(sort));
    }

    @Nullable
    public DBObject findOne(Object id) throws DBCException {
        return this.getDBCollection().findOne(id);
    }

    @Nullable
    public DBObject findOne(Object id, Map<String, Object> projection) throws DBCException {
        return this.getDBCollection().findOne(id, (DBObject)MongoJSUtils.createBasicDocument(projection));
    }

    public long count() throws DBCException {
        return this.getDBCollection().count();
    }

    public long count(@Nullable Map<String, Object> query) throws DBCException {
        return this.getDBCollection().count((DBObject)MongoJSUtils.createBasicDocument(query));
    }

    public Object rename(String newName) throws DBCException {
        this.getDBCollection().rename(newName);
        return this;
    }

    public MongoJSCollection rename(String newName, boolean dropTarget) throws DBCException {
        this.getDBCollection().rename(newName, dropTarget);
        return this;
    }

    @Deprecated
    public DBObject group(Map<String, Object> key, Map<String, Object> cond, Map<String, Object> initial, String reduce) throws DBCException {
        return this.getDBCollection().group((DBObject)MongoJSUtils.createBasicDocument(key), (DBObject)MongoJSUtils.createBasicDocument(cond), (DBObject)MongoJSUtils.createBasicDocument(initial), reduce);
    }

    @Deprecated
    public DBObject group(Map<String, Object> key, Map<String, Object> cond, Map<String, Object> initial, String reduce, @Nullable String finalize) throws DBCException {
        return this.getDBCollection().group((DBObject)MongoJSUtils.createBasicDocument(key), (DBObject)MongoJSUtils.createBasicDocument(cond), (DBObject)MongoJSUtils.createBasicDocument(initial), reduce, finalize);
    }

    public List<?> distinct(String fieldName) throws DBCException {
        return this.getDBCollection().distinct(fieldName);
    }

    public List<?> distinct(String fieldName, Map<String, Object> query) throws DBCException {
        return this.getDBCollection().distinct(fieldName, (DBObject)MongoJSUtils.createBasicDocument(query));
    }

    public String getName() throws DBCException {
        return this.getDBCollection().getName();
    }

    public String getFullName() throws DBCException {
        return this.getDBCollection().getFullName();
    }

    public Object getDBCollection(String name) {
        return this.database.get(name);
    }

    public void createIndex(String name) throws DBCException {
        this.getDBCollection().createIndex((DBObject)new BasicDBObject(name, (Object)1));
    }

    public void createIndex(Map<String, Object> keys, String name) throws DBCException {
        this.getDBCollection().createIndex((DBObject)MongoJSUtils.createBasicDocument(keys), name);
    }

    public void createIndex(Map<String, Object> keys, @Nullable String name, boolean unique) throws DBCException {
        this.getDBCollection().createIndex((DBObject)MongoJSUtils.createBasicDocument(keys), name, unique);
    }

    public void createIndex(Map<String, Object> keys) throws DBCException {
        this.getDBCollection().createIndex((DBObject)MongoJSUtils.createBasicDocument(keys));
    }

    public void createIndex(Map<String, Object> keys, Map<String, Object> options) throws DBCException {
        this.getDBCollection().createIndex((DBObject)MongoJSUtils.createBasicDocument(keys), (DBObject)MongoJSUtils.createBasicDocument(options));
    }

    public List<DBObject> getIndexInfo() throws DBCException {
        return this.getDBCollection().getIndexInfo();
    }

    public void dropIndex(Map<String, Object> index) throws DBCException {
        this.getDBCollection().dropIndex((DBObject)MongoJSUtils.createBasicDocument(index));
    }

    public void dropIndex(String indexName) throws DBCException {
        this.getDBCollection().dropIndex(indexName);
    }

    public void dropIndexes() throws DBCException {
        this.getDBCollection().dropIndexes();
    }

    public void dropIndexes(String indexName) throws DBCException {
        this.getDBCollection().dropIndexes(indexName);
    }

    public CommandResult getStats() throws DBCException {
        return this.getDBCollection().getStats();
    }

    public CommandResult stats() throws DBCException {
        return this.getDBCollection().getStats();
    }

    @Nullable
    public DBObject findAndModify(@Nullable Map<String, Object> query, @Nullable Map<String, Object> sort, Map<String, Object> update) throws DBCException {
        return this.getDBCollection().findAndModify((DBObject)(query == null ? null : MongoJSUtils.createBasicDocument(query)), (DBObject)(sort == null ? null : MongoJSUtils.createBasicDocument(sort)), (DBObject)MongoJSUtils.createBasicDocument(update));
    }

    @Nullable
    public DBObject findAndModify(@Nullable Map<String, Object> query, Map<String, Object> update) throws DBCException {
        return this.getDBCollection().findAndModify((DBObject)(query == null ? null : MongoJSUtils.createBasicDocument(query)), (DBObject)MongoJSUtils.createBasicDocument(update));
    }

    @Nullable
    public DBObject findAndRemove(@Nullable Map<String, Object> query) throws DBCException {
        return this.getDBCollection().findAndRemove((DBObject)(query == null ? null : MongoJSUtils.createBasicDocument(query)));
    }

    @Nullable
    public DBObject findAndModify(@Nullable Map<String, Object> query, @Nullable Map<String, Object> fields, @Nullable Map<String, Object> sort, boolean remove, @Nullable Map<String, Object> update, boolean returnNew, boolean upsert) throws DBCException {
        return this.getDBCollection().findAndModify((DBObject)(query == null ? null : MongoJSUtils.createBasicDocument(query)), (DBObject)(fields == null ? null : MongoJSUtils.createBasicDocument(fields)), (DBObject)(sort == null ? null : MongoJSUtils.createBasicDocument(sort)), remove, (DBObject)(update == null ? null : MongoJSUtils.createBasicDocument(update)), returnNew, upsert);
    }

    public long totalSize() throws DBCException {
        return 0L;
    }
}

