/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.data.MongoDocument;
import com.dbeaver.db.mongodb.exec.MongoBaseStatement;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.model.document.exec.DocumentResultSet;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MongoResultSet
extends DocumentResultSet<MongoSession, MongoBaseStatement>
implements DBRBlockingObject,
DBCResultSetSampleProvider {
    private final DBCursor cursor;
    private final MongoCursor mongoCursor;
    private final List<DBObject> list;
    private DBCResultSetMetaData metaData;
    private Object curRow;

    public MongoResultSet(MongoBaseStatement statement, DBCursor cursor) {
        super((DBCStatement)statement);
        long limit;
        this.cursor = cursor;
        this.mongoCursor = null;
        this.list = null;
        long offset = statement.getOffset();
        if (offset > 0L) {
            this.cursor.skip((int)offset);
        }
        if ((limit = statement.getLimit()) > 0L) {
            this.cursor.batchSize((int)limit);
            this.cursor.limit((int)limit);
        } else if (statement.getResultsFetchSize() > 0) {
            this.cursor.batchSize(statement.getResultsFetchSize());
        }
        if (((MongoSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((MongoSession)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoResultSet(MongoBaseStatement statement, MongoCursor mongoCursor) {
        super((DBCStatement)statement);
        this.mongoCursor = mongoCursor;
        this.cursor = null;
        this.list = null;
        long offset = statement.getOffset();
        if (offset > 0L) {
            int i = 0;
            while ((long)i < offset) {
                if (!this.mongoCursor.hasNext()) break;
                this.mongoCursor.next();
                ++i;
            }
        }
        if (((MongoSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((MongoSession)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoResultSet(MongoBaseStatement statement, List<DBObject> list) {
        super((DBCStatement)statement);
        this.cursor = null;
        this.mongoCursor = null;
        this.list = list;
        if (((MongoSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        ((MongoSession)statement.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoSession getSession() {
        return (MongoSession)((MongoBaseStatement)this.statement).getSession();
    }

    public MongoBaseStatement getSourceStatement() {
        return (MongoBaseStatement)this.statement;
    }

    protected void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (index == 0) {
            return this.curRow;
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        if (this.curRow instanceof Map) {
            return ((Map)this.curRow).get(name);
        }
        return this.curRow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean nextRow() throws DBCException {
        long limit = ((MongoBaseStatement)this.statement).getLimit();
        if (limit > 0L && (long)(this.itemNumber + 1) >= limit) {
            return false;
        }
        if (this.list != null) {
            if (this.list.size() > this.itemNumber + 1) {
                this.curRow = this.list.get(this.itemNumber + 1);
                ++this.itemNumber;
                return true;
            }
            return false;
        }
        try {
            if (this.mongoCursor != null) {
                if (!this.mongoCursor.hasNext()) {
                    this.curRow = null;
                    return false;
                }
                this.curRow = this.mongoCursor.next();
            } else {
                if (this.cursor == null) {
                    throw new DBCException("Null result");
                }
                if (!this.cursor.hasNext()) {
                    this.curRow = null;
                    return false;
                }
                this.curRow = this.cursor.next();
            }
            ++this.itemNumber;
            return true;
        }
        catch (Exception e) {
            throw new DBCException("Error fetching Mongo cursor", (Throwable)e);
        }
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        if ("document".equals(name)) {
            return true;
        }
        return null;
    }

    public void close() {
        ((MongoSession)((MongoBaseStatement)this.statement).getSession()).getProgressMonitor().endBlock();
        if (((MongoSession)((MongoBaseStatement)this.statement).getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.itemNumber);
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        this.cursor.close();
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        ArrayList<Object[]> sample;
        block6: {
            sample = new ArrayList<Object[]>();
            if (this.list != null) {
                for (DBObject object : this.list) {
                    sample.add(new Object[]{new MongoDocument((MGDataSource)session.getDataSource(), object)});
                    if (sample.size() >= maxRows) break;
                }
            }
            try {
                if (this.mongoCursor != null || this.cursor == null) break block6;
                for (DBObject object : this.cursor.copy()) {
                    sample.add(new Object[]{new MongoDocument((MGDataSource)session.getDataSource(), object)});
                    if (sample.size() < maxRows && !session.getProgressMonitor().isCanceled()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new DBCException("Error fetching Mongo cursor", (Throwable)e);
            }
        }
        return sample;
    }
}

