/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.exec.MongoBaseStatement;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSCollection;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.exec.js.MongoJSProcessor;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.CommandResult;
import java.util.Collection;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class MongoEvalStatement
extends MongoBaseStatement {
    private static final Log log = Log.getLog(MongoEvalStatement.class);

    public MongoEvalStatement(MongoSession session, String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            MGDatabase activeDatabase = ((MongoSession)this.getSession()).getExecutionContext().getDefaultCatalog();
            if (activeDatabase == null) {
                throw new DBCException("No current database");
            }
            String js = this.getQueryString();
            if (this.isEvalSupported()) {
                this.runInEval(activeDatabase, js);
            } else {
                try {
                    MongoJSProcessor jsProcessor = MongoJSProcessor.forStatement((MongoSession)this.getSession(), (DBCStatement)this, activeDatabase);
                    Object result = jsProcessor.eval(js);
                    if (result != null && !(result instanceof MongoJSCollection) && !(result instanceof MongoJSDatabase)) {
                        this.setExecutionResult(result);
                    }
                }
                catch (Exception e) {
                    throw new DBCException(GeneralUtils.getRootCause((Throwable)e), (DBCExecutionContext)((MongoSession)this.getSession()).getExecutionContext());
                }
            }
            boolean bl = this.result != null || this.iterableResult != null || !CommonUtils.isEmpty((Collection)this.resultList);
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private boolean isEvalSupported() {
        return ((MongoSession)this.getSession()).getDataSource().isEvalSupported();
    }

    private void runInEval(MGDatabase activeDatabase, String js) throws DBCException {
        js = js.replace('\n', ' ');
        CommandResult commandResult = activeDatabase.getDB((MongoSession)this.getSession()).doEval(js, new Object[0]);
        if (!commandResult.ok()) {
            throw new DBCException("JavaScript error - " + commandResult.getErrorMessage());
        }
        this.setExecutionResult(commandResult);
    }
}

