/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data.handlers;

import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.data.MongoDocument;
import com.dbeaver.db.mongodb.data.MongoListValue;
import com.dbeaver.db.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.sql.MongoCustomStatement;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDComplexValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoDocumentValueHandler
extends MongoBaseValueHandler
implements DBDValueHandlerComposite {
    public static final MongoDocumentValueHandler INSTANCE = new MongoDocumentValueHandler();

    @NotNull
    public Class<DBObject> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBObject.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBObject || value instanceof DBDComplexValue) {
            return value.toString();
        }
        return "#document";
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new MongoDocument((MGDataSource)session.getDataSource(), (DBObject)new BasicDBObject());
        }
        if (object instanceof DBObject) {
            if (copy) {
                object = MongoUtils.cloneObject(object);
            }
            return new MongoDocument((MGDataSource)session.getDataSource(), (DBObject)object);
        }
        if (object instanceof Map) {
            return new MongoDocument((MGDataSource)session.getDataSource(), (DBObject)new BasicDBObject((Map)object));
        }
        if (object instanceof MongoDocument) {
            MongoDocument srcDocument = (MongoDocument)((Object)object);
            return new MongoDocument((MGDataSource)srcDocument.getDataSource(), MongoUtils.cloneObject(srcDocument.getRawValue()));
        }
        return object;
    }

    @Override
    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        DBObject columnValue = (DBObject)super.fetchValueObject(session, resultSet, type, index);
        if (columnValue instanceof BasicDBList) {
            BasicDBObject map = new BasicDBObject("", (Object)columnValue);
            columnValue = map;
        }
        return new MongoDocument((MGDataSource)session.getDataSource(), columnValue);
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        if (type.getDataKind() == DBPDataKind.ARRAY) {
            return new MongoListValue((MGDataSource)session.getDataSource(), (List<Object>)new BasicDBList());
        }
        return new DBMapValue((DBPDataSource)((MGDataSource)session.getDataSource()), null, (Map)new BasicDBObject());
    }
}

