/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatabase;
import com.dbeaver.db.redshift.model.RedshiftDatashareConsumer;
import com.dbeaver.db.redshift.model.RedshiftDatashareObject;
import com.dbeaver.db.redshift.model.RedshiftDatashareObjectType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class RedshiftDatashare
implements DBSObject,
DBPImageProvider {
    private final RedshiftDatabase database;
    private final String shareName;
    private final String shareOwner;
    private final String sourceDatabase;
    private final String consumerDatabase;
    private final String shareType;
    private final Date createDate;
    private final boolean isPublicAccessible;
    private final String shareACL;
    private final String producerAccount;
    private final String producerNamespace;
    private final ConsumerCache consumerCache = new ConsumerCache();
    private final ObjectCache objectCache = new ObjectCache();

    public RedshiftDatashare(RedshiftDatabase database, JDBCResultSet resultSet) {
        this.database = database;
        this.shareName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"share_name");
        this.shareOwner = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"share_owner");
        this.sourceDatabase = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"source_database");
        this.consumerDatabase = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"consumer_database");
        this.shareType = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"share_type");
        this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"createdate");
        this.isPublicAccessible = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"is_publicaccessible");
        this.shareACL = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"share_acl");
        this.producerAccount = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"producer_account");
        this.producerNamespace = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"producer_namespace");
    }

    @Nullable
    public RedshiftDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public RedshiftDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.getShareName();
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getShareName() {
        return this.shareName;
    }

    @Property(viewable=true, order=10)
    public String getShareOwner() {
        return this.shareOwner;
    }

    @Property(viewable=true, order=11)
    public String getSourceDatabase() {
        return this.sourceDatabase;
    }

    @Property(viewable=true, order=12)
    public String getConsumerDatabase() {
        return this.consumerDatabase;
    }

    @Property(viewable=true, order=13)
    public String getShareType() {
        return this.shareType;
    }

    @Property(viewable=true, order=14)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, order=16)
    public boolean getIsPublicAccessible() {
        return this.isPublicAccessible;
    }

    @Property(viewable=true, order=17)
    public String getShareACL() {
        return this.shareACL;
    }

    @Property(viewable=true, order=17)
    public String getProducerAccount() {
        return this.producerAccount;
    }

    @Property(viewable=true, order=17)
    public String getProducerNamespace() {
        return this.producerNamespace;
    }

    @NotNull
    public List<RedshiftDatashareConsumer> getConsumers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.consumerCache.getAllObjects(monitor, this);
    }

    @NotNull
    public List<RedshiftDatashareObject> getObjects(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.objectCache.getAllObjects(monitor, this);
    }

    @NotNull
    public List<RedshiftDatashareObject> getObjects(@NotNull DBRProgressMonitor monitor, RedshiftDatashareObjectType type) throws DBException {
        return this.objectCache.getAllObjects(monitor, this).stream().filter(o -> o.getObjectType() == type).collect(Collectors.toList());
    }

    @Nullable
    public DBPImage getObjectImage() {
        return "OUTBOUND".equalsIgnoreCase(this.shareType) ? DBIcon.TREE_TABLE_INDEX : DBIcon.TREE_TABLE_EXTERNAL;
    }

    static class ConsumerCache
    extends JDBCObjectCache<RedshiftDatashare, RedshiftDatashareConsumer> {
        ConsumerCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull RedshiftDatashare owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SVV_DATASHARE_CONSUMERS WHERE share_name=? ORDER BY consumer_namespace");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected RedshiftDatashareConsumer fetchObject(@NotNull JDBCSession session, @NotNull RedshiftDatashare owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new RedshiftDatashareConsumer(owner, dbResult);
        }
    }

    static class ObjectCache
    extends JDBCObjectCache<RedshiftDatashare, RedshiftDatashareObject> {
        ObjectCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull RedshiftDatashare owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SVV_DATASHARE_OBJECTS WHERE share_name=? ORDER BY object_name");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected RedshiftDatashareObject fetchObject(@NotNull JDBCSession session, @NotNull RedshiftDatashare owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new RedshiftDatashareObject(owner, dbResult);
        }
    }
}

