/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.lightcouch.Params;

class URIBuilder {
    private String scheme;
    private String host;
    private int port;
    private String path = "";
    private final List<String> params = new ArrayList<String>();

    URIBuilder() {
    }

    public static URIBuilder buildUri() {
        return new URIBuilder();
    }

    public static URIBuilder buildUri(URI uri) {
        URIBuilder builder = URIBuilder.buildUri().scheme(uri.getScheme()).host(uri.getHost()).port(uri.getPort()).path(uri.getPath());
        return builder;
    }

    public URIBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public URIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public URIBuilder path(String path) {
        this.path = this.path + path;
        return this;
    }

    public URIBuilder pathEncoded(String path) {
        try {
            this.path = this.path + URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public URIBuilder query(String name, Object value) {
        if (name != null && value != null) {
            try {
                name = URLEncoder.encode(name, "UTF-8");
                value = URLEncoder.encode(String.valueOf(value), "UTF-8");
                this.params.add(String.format("%s=%s", name, value));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    public URIBuilder query(Params params) {
        if (params.getParams() != null) {
            this.params.addAll(params.getParams());
        }
        return this;
    }

    public URI build() {
        StringBuilder query = new StringBuilder();
        for (int i = 0; i < this.params.size(); ++i) {
            String amp = i != this.params.size() - 1 ? "&" : "";
            query.append(this.params.get(i) + amp);
        }
        String q = query.length() == 0 ? "" : "?" + query;
        String uri = String.format("%s://%s:%s%s%s", this.scheme, this.host, this.port, this.path, q);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

