/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.internal.ui.LMUIActivator;
import com.dbeaver.lm.internal.ui.LMUIMessages;
import com.dbeaver.lm.ui.LicenseUIUtils;
import com.dbeaver.lm.validate.LMPublicAPI;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.utils.CommonUtils;

public class LicenseTrialDialog
extends Dialog {
    private final LMLicenseManager licenseManager;
    private final LMProduct product;
    private Text emailText;
    private Text firstNameText;
    private Text lastNameText;
    private Text companyText;
    private ProgressMonitorPart monitorPart;

    public LicenseTrialDialog(Shell parentShell, LMLicenseManager licenseManager, LMProduct product) {
        super(parentShell);
        this.licenseManager = licenseManager;
        this.product = product;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        DBPPreferenceStore prefStore = LMUIActivator.getDefault().getPreferences();
        this.getShell().setText("Trial License");
        Composite composite = (Composite)super.createDialogArea(parent);
        Group infoGroup = UIUtils.createControlGroup((Composite)composite, (String)"User Information", (int)2, (int)1808, (int)0);
        this.emailText = UIUtils.createLabelText((Composite)infoGroup, (String)"E-Mail (*)", (String)CommonUtils.toString((Object)prefStore.getString("trialEmail")));
        this.firstNameText = UIUtils.createLabelText((Composite)infoGroup, (String)"First Name (*)", (String)CommonUtils.toString((Object)prefStore.getString("trialFirstName")));
        this.lastNameText = UIUtils.createLabelText((Composite)infoGroup, (String)"Last Name (*)", (String)CommonUtils.toString((Object)prefStore.getString("trialLastName")));
        this.companyText = UIUtils.createLabelText((Composite)infoGroup, (String)"Company", (String)CommonUtils.toString((Object)prefStore.getString("trialCompany")));
        UIUtils.createLabel((Composite)composite, (String)"In order to generate trial license you have to have internet access.");
        UIUtils.createLink((Composite)composite, (String)"You also can obtain trial license on the <a>web site</a>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.launchProgram((String)"https://dbeaver.com/trial");
            }
        });
        this.monitorPart = new ProgressMonitorPart(composite, null, true){

            public void setCanceled(boolean b) {
                super.setCanceled(b);
                if (b) {
                    LicenseTrialDialog.this.cancelCurrentOperation();
                }
            }
        };
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        this.monitorPart.setLayoutData((Object)gd);
        this.monitorPart.setVisible(false);
        return parent;
    }

    private void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.monitorPart != null) {
            this.monitorPart.setVisible(true);
            this.monitorPart.layout();
            this.monitorPart.attachToCancelComponent(null);
        }
        ControlEnableState buttonsEnableState = ControlEnableState.disable((Control)this.getButtonBar());
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitorPart, (Display)this.getShell().getDisplay());
        }
        finally {
            buttonsEnableState.restore();
            if (this.monitorPart != null) {
                this.monitorPart.done();
                this.monitorPart.setVisible(false);
            }
        }
    }

    private void cancelCurrentOperation() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Generate", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.generateLicense()) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    private boolean generateLicense() {
        try {
            DBPPreferenceStore prefStore = LMUIActivator.getDefault().getPreferences();
            String email = this.validateFieldPresence("E-Mail", ".+@.+\\..+", this.emailText);
            String firstName = this.validateFieldPresence("First Name", "\\w+", this.firstNameText);
            String lastName = this.validateFieldPresence("Last Name", "\\w+", this.lastNameText);
            String company = this.companyText.getText();
            prefStore.setValue("trialEmail", email);
            prefStore.setValue("trialFirstName", firstName);
            prefStore.setValue("trialLastName", lastName);
            prefStore.setValue("trialCompany", company);
            IStatus[] result = new IStatus[1];
            this.run(monitor -> {
                IStatus iStatus = LMPublicAPI.generateTrialLicense((IProgressMonitor)monitor, (LMLicenseManager)this.licenseManager, (String)LicenseUIUtils.getClientId(), (LMProduct)this.product, (String)email, (String)firstName, (String)lastName, (String)company);
            });
            IStatus trial = result[0];
            if (!trial.isOK()) {
                DBWorkbench.getPlatformUI().showError(LMUIMessages.dialog_message_box_title_license_generation_error, LMUIMessages.dialog_message_box_text_license_error, trial);
            }
            return trial.isOK();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showMessageBox("Invalid trial form data", "Invalid form data:\n" + e.getMessage(), true);
            return false;
        }
    }

    private String validateFieldPresence(String fieldName, String pattern, Text text) throws DBException {
        String fieldValue = text.getText();
        if (fieldValue.isEmpty()) {
            text.setFocus();
            throw new DBException("You must enter " + fieldName);
        }
        if (!Pattern.compile(pattern).matcher(fieldValue).matches()) {
            text.setFocus();
            throw new DBException("Invalid field value: " + fieldName);
        }
        return fieldValue;
    }
}

