/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.driver.core.policies;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.yugabyte.driver.core.TableSplitMetadata;
import com.yugabyte.driver.core.utils.Jenkins;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAwarePolicy
implements ChainableLoadBalancingPolicy {
    private final LoadBalancingPolicy childPolicy;
    private volatile Metadata clusterMetadata;
    private Configuration configuration;
    private static final Logger logger = LoggerFactory.getLogger(PartitionAwarePolicy.class);

    public PartitionAwarePolicy(LoadBalancingPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    public PartitionAwarePolicy() {
        this(new DCAwareRoundRobinPolicy.Builder().withUsedHostsPerRemoteDc(Integer.MAX_VALUE).build());
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.clusterMetadata = cluster.getMetadata();
        this.configuration = cluster.getConfiguration();
        this.childPolicy.init(cluster, hosts);
    }

    @Override
    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }

    private static int getKey(byte[] bytes) {
        long SEED = 97L;
        long h = Jenkins.hash64(bytes, 97L);
        long h1 = h >>> 48;
        long h2 = 3L * (h >>> 32);
        long h3 = 5L * (h >>> 16);
        long h4 = 7L * (h & 0xFFFFL);
        return (int)((h1 ^ h2 ^ h3 ^ h4) & 0xFFFFL);
    }

    public static int CqlToYBHashCode(long cql_hash) {
        int hash_code = (int)(cql_hash >> 48);
        return hash_code ^= 0x8000;
    }

    public static long YBToCqlHashCode(int hash) {
        long cql_hash = hash ^ 0x8000;
        return cql_hash <<= 48;
    }

    static int getKey(BoundStatement stmt) {
        PreparedStatement pstmt = stmt.preparedStatement();
        int[] hashIndexes = pstmt.getRoutingKeyIndexes();
        if (hashIndexes == null || hashIndexes.length == 0) {
            return -1;
        }
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            WritableByteChannel channel = Channels.newChannel(bs);
            ColumnDefinitions variables = pstmt.getVariables();
            for (int i = 0; i < hashIndexes.length; ++i) {
                int index = hashIndexes[i];
                DataType type = variables.getType(index);
                ByteBuffer value = stmt.getBytesUnsafe(index);
                PartitionAwarePolicy.AppendValueToChannel(type, value, channel);
            }
            channel.close();
            return PartitionAwarePolicy.getKey(bs.toByteArray());
        }
        catch (IOException e) {
            logger.error("hash key encoding failed", (Throwable)e);
            return -1;
        }
    }

    private static void AppendValueToChannel(DataType type, ByteBuffer value, WritableByteChannel channel) throws IOException {
        DataType.Name typeName = type.getName();
        block0 : switch (typeName) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case ASCII: 
            case TEXT: 
            case JSONB: 
            case VARCHAR: 
            case BLOB: 
            case INET: 
            case UUID: 
            case TIMEUUID: 
            case DATE: 
            case TIME: {
                channel.write(value);
                break;
            }
            case FLOAT: {
                float floatValue = value.getFloat(0);
                value.rewind();
                if (Float.isNaN(floatValue)) {
                    value = ByteBuffer.allocate(4);
                    value.putInt(2143289344);
                    value.flip();
                }
                channel.write(value);
                break;
            }
            case DOUBLE: {
                double doubleValue = value.getDouble(0);
                value.rewind();
                if (Double.isNaN(doubleValue)) {
                    value = ByteBuffer.allocate(8);
                    value.putLong(9221120237041090560L);
                    value.flip();
                }
                channel.write(value);
                break;
            }
            case TIMESTAMP: {
                ByteBuffer bb = ByteBuffer.allocate(8);
                bb.putLong(value.getLong() * 1000L);
                bb.flip();
                value = bb;
                channel.write(value);
                break;
            }
            case LIST: 
            case SET: {
                List<DataType> typeArgs = type.getTypeArguments();
                int length = value.getInt();
                for (int j = 0; j < length; ++j) {
                    int size = value.getInt();
                    ByteBuffer buf = value.slice();
                    buf.limit(size);
                    PartitionAwarePolicy.AppendValueToChannel(typeArgs.get(0), buf, channel);
                    value.position(value.position() + size);
                }
                break;
            }
            case MAP: {
                List<DataType> typeArgs = type.getTypeArguments();
                int length = value.getInt();
                for (int j = 0; j < length; ++j) {
                    int size = value.getInt();
                    ByteBuffer buf = value.slice();
                    buf.limit(size);
                    PartitionAwarePolicy.AppendValueToChannel(typeArgs.get(0), buf, channel);
                    value.position(value.position() + size);
                    size = value.getInt();
                    buf = value.slice();
                    buf.limit(size);
                    PartitionAwarePolicy.AppendValueToChannel(typeArgs.get(1), buf, channel);
                    value.position(value.position() + size);
                }
                break;
            }
            case UDT: {
                for (UserType.Field field : (UserType)type) {
                    if (!value.hasRemaining()) break block0;
                    int size = value.getInt();
                    ByteBuffer buf = value.slice();
                    buf.limit(size);
                    PartitionAwarePolicy.AppendValueToChannel(field.getType(), buf, channel);
                    value.position(value.position() + size);
                }
                break;
            }
            case COUNTER: 
            case CUSTOM: 
            case DECIMAL: 
            case TUPLE: 
            case VARINT: {
                throw new UnsupportedOperationException("Datatype " + typeName.toString() + " not supported in a partition key column");
            }
        }
    }

    private Iterator<Host> getQueryPlan(String loggedKeyspace, BoundStatement statement) {
        PreparedStatement pstmt = statement.preparedStatement();
        String query = pstmt.getQueryString();
        ColumnDefinitions variables = pstmt.getVariables();
        if (variables.size() == 0) {
            return null;
        }
        logger.debug("getQueryPlan: keyspace = " + loggedKeyspace + ", query = " + query);
        int key = PartitionAwarePolicy.getKey(statement);
        if (key < 0) {
            return null;
        }
        TableSplitMetadata tableSplitMetadata = this.clusterMetadata.getTableSplitMetadata(variables.getKeyspace(0), variables.getTable(0));
        if (tableSplitMetadata == null) {
            return null;
        }
        return new UpHostIterator(loggedKeyspace, statement, tableSplitMetadata.getHosts(key));
    }

    private Iterator<Host> getQueryPlan(String loggedKeyspace, BatchStatement batch) {
        for (Statement statement : batch.getStatements()) {
            Iterator<Host> plan;
            if (!(statement instanceof BoundStatement) || (plan = this.getQueryPlan(loggedKeyspace, (BoundStatement)statement)) == null) continue;
            return plan;
        }
        return null;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        Iterator<Host> plan = null;
        if (statement instanceof BoundStatement) {
            plan = this.getQueryPlan(loggedKeyspace, (BoundStatement)statement);
        } else if (statement instanceof BatchStatement) {
            plan = this.getQueryPlan(loggedKeyspace, (BatchStatement)statement);
        }
        return plan != null ? plan : this.childPolicy.newQueryPlan(loggedKeyspace, statement);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.childPolicy.distance(host);
    }

    @Override
    public void onAdd(Host host) {
        this.childPolicy.onAdd(host);
    }

    @Override
    public void onUp(Host host) {
        this.childPolicy.onUp(host);
    }

    @Override
    public void onDown(Host host) {
        this.childPolicy.onDown(host);
    }

    @Override
    public void onRemove(Host host) {
        this.childPolicy.onRemove(host);
    }

    @Override
    public void close() {
        this.childPolicy.close();
    }

    private class UpHostIterator
    implements Iterator<Host> {
        private final String loggedKeyspace;
        private final Statement statement;
        private final List<Host> hosts;
        private final Iterator<Host> iterator;
        private Iterator<Host> childIterator;
        private Host nextHost;

        public UpHostIterator(String loggedKeyspace, Statement statement, List<Host> hosts) {
            this.loggedKeyspace = loggedKeyspace;
            this.statement = statement;
            if (this.getConsistencyLevel() == ConsistencyLevel.YB_CONSISTENT_PREFIX) {
                Collections.shuffle(hosts);
            }
            this.hosts = hosts;
            this.iterator = hosts.iterator();
        }

        private ConsistencyLevel getConsistencyLevel() {
            return this.statement.getConsistencyLevel() != null ? this.statement.getConsistencyLevel() : PartitionAwarePolicy.this.configuration.getQueryOptions().getConsistencyLevel();
        }

        @Override
        public boolean hasNext() {
            while (this.iterator.hasNext()) {
                this.nextHost = this.iterator.next();
                if (!this.nextHost.isUp() || PartitionAwarePolicy.this.childPolicy.distance(this.nextHost) != HostDistance.LOCAL && !this.getConsistencyLevel().isYBStrong()) continue;
                return true;
            }
            if (this.childIterator == null) {
                this.childIterator = PartitionAwarePolicy.this.childPolicy.newQueryPlan(this.loggedKeyspace, this.statement);
            }
            while (this.childIterator.hasNext()) {
                this.nextHost = this.childIterator.next();
                if (this.hosts.contains(this.nextHost) && (PartitionAwarePolicy.this.childPolicy.distance(this.nextHost) == HostDistance.LOCAL || this.statement.getConsistencyLevel() == ConsistencyLevel.YB_STRONG)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Host next() {
            return this.nextHost;
        }
    }
}

