/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.model.document.handlers;

import com.dbeaver.ee.model.document.handlers.DocumentBaseValueHandler;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandlerConfigurable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DocumentNumberValueHandler
extends DocumentBaseValueHandler
implements DBDValueHandlerConfigurable {
    private static final Log log = Log.getLog(DocumentNumberValueHandler.class);
    private final DBDFormatSettings formatSettings;
    private final boolean useScientificNotation;
    private DBDDataFormatter formatter;

    public DocumentNumberValueHandler(DBSTypedObject type, DBDFormatSettings formatSettings) {
        this.formatSettings = formatSettings;
        this.useScientificNotation = formatSettings.isUseScientificNumericFormat();
    }

    public void refreshValueHandlerConfiguration(DBSTypedObject type) {
        this.formatter = null;
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (DBUtils.isNullValue((Object)value)) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)format);
        }
        if (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT) {
            if (value instanceof Number) {
                return DBValueFormatting.convertNumberToNativeString((Number)((Number)value), (boolean)this.useScientificNotation);
            }
            return value.toString();
        }
        return this.getFormatter(column).formatValue(value);
    }

    public DBDDataFormatter getFormatter(@NotNull DBSTypedObject column) {
        if (this.formatter == null) {
            try {
                this.formatter = this.formatSettings.getDataFormatterProfile().createFormatter("number", column);
            }
            catch (Exception e) {
                log.error((Object)"Can't create formatter for number value handler", (Throwable)e);
                this.formatter = DefaultDataFormatter.INSTANCE;
            }
        }
        return this.formatter;
    }

    @NotNull
    public Class<? extends Number> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return this.getNumberType(attribute);
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object;
        }
        Class<Number> numberType = Number.class;
        return DBValueFormatting.convertStringToNumber((String)object.toString(), numberType, (DBDDataFormatter)this.getFormatter(type), (boolean)validateValue);
    }

    public Class<? extends Number> getNumberType(DBSTypedObject type) {
        return Double.class;
    }
}

