/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.model.document.handlers;

import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.BaseValueHandler;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class DocumentBaseValueHandler
extends BaseValueHandler {
    private static final Log log = Log.getLog(DocumentBaseValueHandler.class);

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        if (type instanceof DBSAttributeBase && type.getDataKind() != DBPDataKind.DOCUMENT) {
            return resultSet.getAttributeValue(((DBSAttributeBase)type).getName());
        }
        return resultSet.getAttributeValue(index);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        DBPDataKind dataKind = attribute.getDataKind();
        if (dataKind == DBPDataKind.BOOLEAN) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
        } else if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.ROWID) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
            operators.add(DBCLogicalOperator.GREATER);
            operators.add(DBCLogicalOperator.LESS);
            operators.add(DBCLogicalOperator.IN);
            if (dataKind == DBPDataKind.STRING) {
                operators.add(DBCLogicalOperator.LIKE);
            }
        }
        return operators.toArray(new DBCLogicalOperator[0]);
    }
}

