/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;

public class VerticaTable
extends GenericTable
implements DBPObjectStatistics,
DBPSystemObject {
    private long tableSize = -1L;
    private String partitionExpression;
    private Date createTime;
    private boolean isTempTable;
    private boolean isSystemTable;
    private boolean hasAggregateProjection;

    public VerticaTable(VerticaSchema container, String tableName, String tableType, JDBCResultSet dbResult) {
        super((GenericStructContainer)container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.partitionExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partition_expression");
            this.createTime = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"create_time");
            this.isTempTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_temp_table");
            this.isSystemTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_system_table");
            this.hasAggregateProjection = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"has_aggregate_projection");
        }
    }

    @Property(viewable=true, order=5)
    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    @Property(viewable=true, order=6)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=7)
    public boolean isTempTable() {
        return this.isTempTable;
    }

    public boolean isSystem() {
        return this.isSystemTable;
    }

    @Property(viewable=true, order=8)
    public boolean isHasAggregateProjection() {
        return this.hasAggregateProjection;
    }

    public boolean isPhysicalTable() {
        return !this.isView();
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = dbResult.getLong("used_bytes");
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }
}

