/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.vertica.VerticaConstants;
import org.jkiss.dbeaver.ext.vertica.VerticaUtils;
import org.jkiss.dbeaver.ext.vertica.model.QueryTransformerLimitVertica;
import org.jkiss.dbeaver.ext.vertica.model.VerticaConstraint;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaFlexTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSequence;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSystemTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTableColumn;
import org.jkiss.dbeaver.ext.vertica.model.VerticaView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class VerticaMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(VerticaMetaModel.class);
    private Boolean childObjectColumnAvailable;

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new VerticaDataSource(monitor, container, this);
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new VerticaSchema(dataSource, catalog, schemaName);
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, GenericStructContainer owner, GenericTableBase table, String objectName) throws SQLException {
        JDBCPreparedStatement dbStat;
        if (owner instanceof VerticaSchema && ((VerticaSchema)owner).isSystem()) {
            String sql = "SELECT st.table_schema as table_schem, st.table_description as remarks, 'SYSTEM TABLE' as table_type, st.*\nfrom v_catalog.system_tables st where st.table_schema =?" + (table != null ? " and st.table_name=?" : "");
            dbStat = session.prepareStatement(sql);
            dbStat.setString(1, owner.getName());
            if (table != null) {
                dbStat.setString(2, table.getName());
            }
        } else {
            String sql = "SELECT t.table_schema as table_schem, t.table_name, t.create_time, t.is_temp_table, t.is_system_table, t.has_aggregate_projection, t.partition_expression, case when is_flextable = true THEN 'FLEX TABLE' else 'TABLE' end as table_type, com.\"comment\" as remarks\nFROM v_catalog.tables t LEFT JOIN v_catalog.comments com ON com.object_type = 'TABLE'\nAND com.object_schema = t.table_schema\nAND com.object_name = t.table_name\n" + (owner instanceof VerticaSchema ? "WHERE t.table_schema=?" + (table != null ? " and t.table_name = ?" : "") : "") + "\nUNION ALL\n" + "SELECT v.table_schema as table_schem, v.table_name, v.create_time, v.is_local_temp_view as is_temp_table, v.is_system_view as is_system_table, false as has_aggregate_projection, " + "null as partition_expression, 'VIEW' as table_type, com.\"comment\" as remarks\n" + "FROM v_catalog.views v LEFT JOIN v_catalog.comments com ON com.object_type = 'VIEW'\n" + "AND com.object_schema = v.table_schema\n" + "AND com.object_name = v.table_name\n" + (owner instanceof VerticaSchema ? "WHERE v.table_schema=?" + (table != null ? " and v.table_name = ?" : "") : "");
            dbStat = session.prepareStatement(sql);
            if (owner instanceof VerticaSchema) {
                dbStat.setString(1, owner.getName());
                if (table != null) {
                    dbStat.setString(2, table.getName());
                    dbStat.setString(3, owner.getName());
                    dbStat.setString(4, table.getName());
                } else {
                    dbStat.setString(2, owner.getName());
                }
            }
        }
        return dbStat;
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        VerticaSchema schema = (VerticaSchema)container;
        if (CommonUtils.isNotEmpty((String)tableType)) {
            if (this.isView(tableType)) {
                return new VerticaView(schema, tableName, tableType, dbResult);
            }
            if (tableType.equals(VerticaConstants.TYPE_FLEX_TABLE)) {
                return new VerticaFlexTable(schema, tableName, tableType, dbResult);
            }
            if (tableType.equals(VerticaConstants.TYPE_SYSTEM_TABLE)) {
                return new VerticaSystemTable(schema, tableName, tableType, dbResult);
            }
            return new VerticaTable(schema, tableName, tableType, dbResult);
        }
        return new VerticaTable(schema, tableName, tableType, dbResult);
    }

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        boolean supportsCommentReading = this.isChildCommentColumnAvailable(session.getProgressMonitor(), (DBPDataSource)owner.getDataSource());
        StringBuilder ddl = new StringBuilder();
        ddl.append("SELECT ");
        if (supportsCommentReading) {
            ddl.append("com.comment AS REMARKS,");
        }
        ddl.append("col.*, col.sql_type_id AS SOURCE_DATA_TYPE, col.data_type_name AS TYPE_NAME, col.column_default AS COLUMN_DEF FROM v_catalog.odbc_columns col ");
        if (supportsCommentReading) {
            ddl.append("LEFT JOIN v_catalog.comments com ON com.object_type = 'COLUMN' AND com.object_schema = col.schema_name AND com.object_name = col.table_name AND com.child_object = col.column_name ");
        }
        ddl.append("WHERE col.schema_name=? ");
        if (forTable != null) {
            ddl.append("AND col.table_name=? ");
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(ddl.toString());
        if (forTable != null) {
            dbStat.setString(1, forTable.getSchema().getName());
            dbStat.setString(2, forTable.getName());
        } else {
            dbStat.setString(1, owner.getSchema().getName());
        }
        return dbStat;
    }

    private boolean isChildCommentColumnAvailable(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource) {
        if (this.childObjectColumnAvailable == null) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Check child comment column existence");){
                    Throwable throwable2 = null;
                    Object var7_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT child_object FROM v_catalog.comments WHERE 1<>1");){
                        dbStat.setFetchSize(1);
                        dbStat.execute();
                        this.childObjectColumnAvailable = true;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                this.childObjectColumnAvailable = false;
            }
        }
        return this.childObjectColumnAvailable;
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        if (dbResult != null) {
            autoIncrement = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_identity");
        }
        return new VerticaTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public String getTableDDL(DBRProgressMonitor monitor, GenericTableBase sourceObject, Map<String, Object> options) throws DBException {
        GenericDataSource dataSource = (GenericDataSource)sourceObject.getDataSource();
        if (sourceObject.isPersisted()) {
            return VerticaUtils.getObjectDDL(monitor, dataSource, (DBSObject)sourceObject);
        }
        return super.getTableDDL(monitor, sourceObject, options);
    }

    public boolean supportsTableDDLSplit(GenericTableBase sourceObject) {
        return false;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return this.getTableDDL(monitor, (GenericTableBase)sourceObject, options);
    }

    /*
     * Exception decompiling
     */
    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supportsOverloadedProcedureNames() {
        return true;
    }

    public boolean showProcedureParamNames() {
        return true;
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<GenericSequence> loadSequences(@NotNull DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read sequences");){
                ArrayList<GenericSequence> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block32: {
                    throwable2 = null;
                    Object var7_11 = null;
                    dbStat = session.prepareStatement("SELECT s.*, c.comment FROM v_catalog.sequences s\nLEFT JOIN v_catalog.comments c\nON s.sequence_id = c.object_id\nWHERE sequence_schema=? ORDER BY sequence_name");
                    dbStat.setString(1, container.getSchema().getName());
                    ArrayList<GenericSequence> result = new ArrayList<GenericSequence>();
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sequence_name");
                            if (name == null) continue;
                            name = name.trim();
                            VerticaSequence sequence = new VerticaSequence(container, name, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"current_value"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"minimum"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"maximum"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"increment_by"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"identity_table_name"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"session_cache_count"), JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"allow_cycle"));
                            result.add(sequence);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block32;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimitVertica();
        }
        return null;
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException, DBException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT col.constraint_name as PK_NAME, col.table_name as TABLE_NAME, col.column_name as COLUMN_NAME, c.ordinal_position as KEY_SEQ, col.constraint_type, tc.predicate, com.comment, col.is_enabled \nFROM v_catalog.constraint_columns col\nLEFT JOIN v_catalog.columns c ON\nc.table_id = col.table_id\nLEFT JOIN v_catalog.comments com ON\ncom.object_id = col.constraint_id\nJOIN v_catalog.table_constraints tc ON\ntc.constraint_id = col.constraint_id \nAND col.column_name = c.column_name \nWHERE col.constraint_type IN ('u','p','c')\nAND col.table_schema = ?" + (forParent != null ? " AND col.table_name = ?" : "") + " ORDER BY col.table_id, KEY_SEQ, PK_NAME");
        if (forParent != null) {
            dbStat.setString(1, forParent.getSchema().getName());
            dbStat.setString(2, forParent.getName());
        } else {
            dbStat.setString(1, owner.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) throws DBException, SQLException {
        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"constraint_type");
        if (type != null) {
            if ("u".equals(type)) {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            if ("c".equals(type)) {
                return DBSEntityConstraintType.CHECK;
            }
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        return super.getUniqueConstraintType(dbResult);
    }

    public GenericUniqueKey createConstraintImpl(GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        String checkExpression = "";
        String comment = null;
        boolean isEnabled = false;
        if (dbResult != null) {
            checkExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"predicate");
            comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
            isEnabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_enabled");
        }
        return new VerticaConstraint(table, constraintName, comment, constraintType, persisted, CommonUtils.notEmpty((String)checkExpression).trim(), isEnabled);
    }

    public boolean supportsCheckConstraints() {
        return true;
    }
}

