/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.model;

import com.dbeaver.ee.model.NoSQLDialect;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CouchDBSQLDialect
extends NoSQLDialect {
    public static final CouchDBSQLDialect INSTANCE = new CouchDBSQLDialect();
    public static final String[][] DEFAULT_IDENTIFIER_QUOTES = new String[][]{{"`", "`"}};

    public CouchDBSQLDialect() {
        this.addKeywords(Arrays.asList("limit", "offset"), DBPKeywordType.KEYWORD);
    }

    @NotNull
    public String getDialectId() {
        return "couchdb";
    }

    @NotNull
    public String getDialectName() {
        return "CouchDB";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    public String addFiltersToQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, String query, DBDDataFilter filter) {
        return SQLSemanticProcessor.injectFiltersToQuery((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)query, (DBDDataFilter)filter);
    }

    @NotNull
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_IDENTIFIER_QUOTES;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean supportsAliasInSelect() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsSubqueries() {
        return false;
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (attribute.getDataKind() == DBPDataKind.OBJECT) {
            return "'" + value + "'";
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }
}

