/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.exec;

import com.dbeaver.db.couchdb.data.CouchDBDocument;
import com.dbeaver.db.couchdb.exec.CouchDBAbstractStatement;
import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.dbeaver.db.couchdb.model.CouchDBDatabase;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CouchDBUpdateStatement
extends CouchDBAbstractStatement {
    private CouchDBDatabase database;
    private DBSAttributeBase[] keyAttributes;
    private DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public CouchDBUpdateStatement(CouchDBSession session, CouchDBDatabase database, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session);
        this.database = database;
        this.keyAttributes = keyAttributes;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        return null;
    }

    public boolean executeStatement() throws DBCException {
        try {
            if (this.rowValues.length <= 1 || this.keyAttributes.length != 1 || this.keyAttributes[0].getDataKind() != DBPDataKind.DOCUMENT) {
                throw new DBCException("Unsupported document value: " + Arrays.toString(this.valueAttributes));
            }
            Map<String, Object> json = ((CouchDBDocument)((Object)this.rowValues[this.valueAttributes.length])).getPlainMap();
            JsonObject o = (JsonObject)CouchDBDataSource.GSON.toJsonTree(json);
            this.database.getClient().post((Object)o);
            return false;
        }
        catch (Throwable e) {
            throw new DBCException("Error saving document", e);
        }
    }
}

