/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLStringAggFunction
extends AggregateFunction {
    boolean isDistinct;
    Expression expression;
    Expression delimiter;
    ArrayList<Object> aggregateValues = new ArrayList();
    LinkedHashSet<Object> distinctAggregateValues = new LinkedHashSet();

    public SQLStringAggFunction(boolean isDistinct, Expression expression, Expression delimiter) {
        this.isDistinct = isDistinct;
        this.expression = expression;
        this.delimiter = delimiter;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        String stringAggregation = null;
        Object o = env.get("@GROUPROWS");
        Object o2 = this.delimiter.eval(env);
        if (o != null) {
            StringBuffer sb = new StringBuffer();
            List groupRows = (List)o;
            for (int i = 0; i < groupRows.size(); ++i) {
                o = this.expression.eval((Map)groupRows.get(i));
                if (o == null) continue;
                if (sb.length() > 0 && o2 != null) {
                    sb.append(o2.toString());
                }
                sb.append(o.toString());
            }
            stringAggregation = sb.toString();
        } else {
            StringBuffer sb = new StringBuffer();
            Iterator<Object> it = this.aggregateValues.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0 && o2 != null) {
                    sb.append(o2.toString());
                }
                sb.append(it.next().toString());
            }
            it = this.distinctAggregateValues.iterator();
            while (it.hasNext()) {
                if (sb.length() > 0 && o2 != null) {
                    sb.append(o2.toString());
                }
                sb.append(it.next().toString());
            }
            stringAggregation = sb.toString();
        }
        return stringAggregation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("STRING_AGG(");
        if (this.isDistinct) {
            sb.append("DISTINCT ");
        }
        sb.append(this.expression);
        sb.append(", ");
        sb.append(this.delimiter);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.delimiter.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<String> aggregateColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.add(this);
        return result;
    }

    @Override
    public void resetAggregateFunctions() {
        this.distinctAggregateValues.clear();
        this.aggregateValues.clear();
    }

    @Override
    public void processRow(Map<String, Object> env) throws SQLException {
        Object o = this.expression.eval(env);
        if (o != null) {
            if (this.isDistinct) {
                this.distinctAggregateValues.add(o);
            } else {
                this.aggregateValues.add(o);
            }
        }
    }
}

