/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLAbsFunction
extends Expression {
    Expression expression;

    public SQLAbsFunction(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Number retval = null;
        Object o = this.expression.eval(env);
        if (o != null) {
            if (!(o instanceof Number)) {
                try {
                    o = new Double(o.toString());
                }
                catch (NumberFormatException e) {
                    o = null;
                }
            }
            if (o != null) {
                if (o instanceof Short) {
                    int i = ((Short)o).intValue();
                    if (i < 0) {
                        i = -i;
                    }
                    retval = i;
                } else if (o instanceof Integer) {
                    int i = (Integer)o;
                    if (i < 0) {
                        i = -i;
                    }
                    retval = i;
                } else if (o instanceof Long) {
                    long l = ((Long)o).intValue();
                    if (l < 0L) {
                        l = -l;
                    }
                    retval = l;
                } else {
                    double d = ((Number)o).doubleValue();
                    if (d < 0.0) {
                        d = -d;
                    }
                    retval = new Double(d);
                }
            }
        }
        return retval;
    }

    public String toString() {
        return "ABS(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression.aggregateFunctions());
        return result;
    }
}

