/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.JoinType;
import org.relique.jdbc.csv.ParsedExpression;
import org.relique.jdbc.csv.ParsedTable;
import org.relique.jdbc.csv.QueryEnvEntry;

class ParsedStatement {
    List<ParsedExpression> queryEntries;
    boolean isDistinct;
    List<ParsedTable> tableEntries;
    ParsedExpression whereClause;
    List<ParsedExpression> groupByEntries;
    ParsedExpression havingClause;
    List<ParsedExpression> orderByEntries;
    int limit;
    int offset;

    public ParsedStatement(List<ParsedExpression> queryEntries, boolean isDistinct, List<ParsedTable> tableEntries, ParsedExpression whereClause, List<ParsedExpression> groupByEntries, ParsedExpression havingClause, List<ParsedExpression> orderByEntries, int limit, int offset) {
        this.queryEntries = queryEntries;
        this.isDistinct = isDistinct;
        this.tableEntries = tableEntries;
        this.whereClause = whereClause;
        this.groupByEntries = groupByEntries;
        this.havingClause = havingClause;
        this.orderByEntries = orderByEntries;
        this.limit = limit;
        this.offset = offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT");
        if (this.isDistinct) {
            sb.append(" DISTINCT");
        }
        String separator = " ";
        for (ParsedExpression expr : this.queryEntries) {
            sb.append(separator);
            separator = ", ";
            QueryEnvEntry queryEnvEntry = (QueryEnvEntry)expr.content;
            sb.append(queryEnvEntry.getExpression().toString());
        }
        if (this.tableEntries != null) {
            int tableCounter = 0;
            for (ParsedTable parsedTable : this.tableEntries) {
                if (tableCounter == 0) {
                    sb.append(" FROM");
                } else {
                    JoinType joinType = parsedTable.getJoinType();
                    if (joinType == JoinType.CROSS) {
                        sb.append(" CROSS JOIN");
                    } else if (joinType == JoinType.INNER) {
                        sb.append(" INNER JOIN");
                    } else if (joinType == JoinType.LEFT_OUTER) {
                        sb.append(" LEFT OUTER JOIN");
                    } else if (joinType == JoinType.RIGHT_OUTER) {
                        sb.append(" RIGHT OUTER JOIN");
                    } else if (joinType == JoinType.FULL_OUTER) {
                        sb.append(" FULL OUTER JOIN");
                    }
                }
                sb.append(" ");
                if (parsedTable.isDerivedTable()) {
                    sb.append("(");
                    sb.append(parsedTable.getDerivedTableStatement().toString());
                    sb.append(")");
                } else {
                    sb.append(parsedTable.getTableName());
                }
                String tableAlias = parsedTable.getTableAlias();
                if (tableAlias != null) {
                    sb.append(" ");
                    sb.append(tableAlias);
                }
                if (tableCounter > 0 && parsedTable.getJoinType() != JoinType.CROSS) {
                    sb.append(" ON ");
                    sb.append(parsedTable.getJoinClause().toString());
                }
                ++tableCounter;
            }
            if (this.whereClause != null) {
                sb.append(" WHERE ").append(this.whereClause.toString());
            }
            if (this.groupByEntries != null && this.groupByEntries.size() > 0) {
                sb.append(" GROUP BY");
                separator = " ";
                for (ParsedExpression expr : this.groupByEntries) {
                    sb.append(separator);
                    separator = ", ";
                    sb.append(expr.toString());
                }
                if (this.havingClause != null) {
                    sb.append(" HAVING ");
                    sb.append(this.havingClause.toString());
                }
            }
            if (this.orderByEntries != null && this.orderByEntries.size() > 0) {
                sb.append(" ORDER BY");
                separator = " ";
                for (ParsedExpression expr : this.orderByEntries) {
                    sb.append(separator);
                    separator = ", ";
                    sb.append(expr.toString());
                }
            }
        }
        if (this.limit >= 0) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.offset > 0) {
            sb.append(" OFFSET ").append(this.offset);
        }
        return sb.toString();
    }

    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        if (this.queryEntries != null) {
            for (ParsedExpression parsedExpr : this.queryEntries) {
                QueryEnvEntry queryEnvEntry = (QueryEnvEntry)parsedExpr.content;
                List<String> columns = queryEnvEntry.getExpression().usedColumns(availableColumns);
                result.addAll(columns);
            }
        }
        if (this.whereClause != null) {
            result.addAll(this.whereClause.usedColumns(availableColumns));
        }
        if (this.groupByEntries != null) {
            for (ParsedExpression groupByExpr : this.groupByEntries) {
                result.addAll(groupByExpr.usedColumns(availableColumns));
            }
        }
        if (this.havingClause != null) {
            result.addAll(this.havingClause.usedColumns(availableColumns));
        }
        if (this.orderByEntries != null) {
            for (ParsedExpression orderByExpr : this.orderByEntries) {
                result.addAll(orderByExpr.usedColumns(availableColumns));
            }
        }
        return result;
    }

    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        if (this.queryEntries != null) {
            for (ParsedExpression parsedExpr : this.queryEntries) {
                QueryEnvEntry queryEnvEntry = (QueryEnvEntry)parsedExpr.content;
                List<AggregateFunction> functions = queryEnvEntry.getExpression().aggregateFunctions();
                result.addAll(functions);
            }
        }
        if (this.whereClause != null) {
            result.addAll(this.whereClause.aggregateFunctions());
        }
        if (this.groupByEntries != null) {
            for (ParsedExpression groupByExpr : this.groupByEntries) {
                result.addAll(groupByExpr.aggregateFunctions());
            }
        }
        if (this.havingClause != null) {
            result.addAll(this.havingClause.aggregateFunctions());
        }
        if (this.orderByEntries != null) {
            for (ParsedExpression orderByExpr : this.orderByEntries) {
                result.addAll(orderByExpr.aggregateFunctions());
            }
        }
        return result;
    }
}

