/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relique.io.CryptoFilter;
import org.relique.io.DataReader;
import org.relique.io.EncryptedFileInputStream;
import org.relique.io.FileSetInputStream;
import org.relique.io.ListDataReader;
import org.relique.io.TableReader;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvRawReader;
import org.relique.jdbc.csv.CsvReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvResultSet;
import org.relique.jdbc.csv.MultipleSqlParser;
import org.relique.jdbc.csv.SqlParser;
import org.relique.jdbc.dbf.DbfReader;

public class CsvStatement
implements Statement {
    public static final String STATEMENT_COLUMN_NAME = "@STATEMENT";
    private CsvConnection connection;
    protected ResultSet lastResultSet = null;
    protected List<SqlParser> multipleParsers = null;
    private int maxRows = 0;
    private int fetchSize = 1;
    private int queryTimeout = Integer.MAX_VALUE;
    private long timeoutMillis = Long.MAX_VALUE;
    private int fetchDirection = 1000;
    private boolean closed;
    protected boolean cancelled;
    protected int resultSetType = 1004;

    protected CsvStatement(CsvConnection connection, int resultSetType) {
        CsvDriver.writeLog("CsvStatement() - connection=" + connection);
        CsvDriver.writeLog("CsvStatement() - Asked for " + (resultSetType == 1005 ? "Scrollable" : "Not Scrollable"));
        this.connection = connection;
        this.resultSetType = resultSetType;
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(CsvResources.getString("statementClosed"));
        }
    }

    @Override
    public void setMaxFieldSize(int p0) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setMaxFieldSize(int)");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkOpen();
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setEscapeProcessing(boolean)");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setCursorName(String)");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException(CsvResources.getString("unsupportedDirection") + ": " + direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this.fetchSize = rows;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": getMaxFieldSize()");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.lastResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        boolean retval;
        this.checkOpen();
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
        }
        if (this.multipleParsers != null && this.multipleParsers.size() > 0) {
            this.lastResultSet = this.executeParsedQuery(this.multipleParsers.remove(0));
            retval = true;
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        CsvDriver.writeLog("CsvStatement:executeQuery() - sql= " + sql);
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
            this.multipleParsers = null;
        }
        this.setTimeoutMillis();
        this.cancelled = false;
        SqlParser parser = new SqlParser();
        try {
            parser.parse(sql);
        }
        catch (Exception e) {
            throw new SQLException(CsvResources.getString("syntaxError") + ": " + e.getMessage());
        }
        return this.executeParsedQuery(parser);
    }

    protected ResultSet executeParsedQuery(SqlParser parser) throws SQLException {
        ResultSet resultSet;
        HashMap<String, Object> parentobjectEnvironment = new HashMap<String, Object>();
        this.lastResultSet = resultSet = this.executeParsedQuery(parser, parentobjectEnvironment);
        return resultSet;
    }

    protected ResultSet executeParsedQuery(SqlParser parser, Map<String, Object> parentobjectEnvironment) throws SQLException {
        if (parser.getTableNames().size() > 1) {
            throw new SQLException(CsvResources.getString("joinNotSupported"));
        }
        String tableName = null;
        if (parser.getTableNames().size() > 0) {
            tableName = parser.getTableNames().get(0);
        }
        String tableAlias = null;
        if (parser.getTableAliases().size() > 0) {
            tableAlias = parser.getTableAliases().get(0);
        }
        String path = this.connection.getPath();
        TableReader tableReader = this.connection.getTableReader();
        if (path != null) {
            CsvDriver.writeLog("Connection Path: " + path);
        } else {
            CsvDriver.writeLog("Connection TableReader: " + tableReader.getClass().getName());
        }
        CsvDriver.writeLog("Parser Table Name: " + tableName);
        CsvDriver.writeLog("Connection Extension: " + this.connection.getExtension());
        DataReader reader = null;
        String fileName = null;
        if (tableName == null) {
            String[] columnNames = new String[]{};
            String[] columnTypes = new String[]{};
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            rows.add(new Object[0]);
            reader = new ListDataReader(columnNames, columnTypes, rows);
        } else {
            if (path != null && !this.connection.isIndexedFiles()) {
                fileName = path + tableName + this.connection.getExtension();
                CsvDriver.writeLog("CSV file name: " + fileName);
                File checkFile = new File(fileName);
                if (!checkFile.exists()) {
                    throw new SQLException(CsvResources.getString("fileNotFound") + ": " + fileName);
                }
                if (!checkFile.canRead()) {
                    throw new SQLException(CsvResources.getString("fileNotReadable") + ": " + fileName);
                }
            }
            try {
                if (this.connection.getExtension().equalsIgnoreCase(".dbf")) {
                    reader = new DbfReader(fileName, tableName, tableAlias, this.connection.getCharset());
                } else {
                    LineNumberReader input;
                    if (tableReader == null) {
                        InputStream in;
                        CryptoFilter filter = this.connection.getDecryptingCodec();
                        if (this.connection.isIndexedFiles()) {
                            String fileNamePattern = tableName + this.connection.getFileNamePattern() + this.connection.getExtension();
                            String[] nameParts = this.connection.getNameParts();
                            String dirName = this.connection.getPath();
                            in = new FileSetInputStream(dirName, fileNamePattern, nameParts, this.connection.getSeparator(), this.connection.isFileTailPrepend(), this.connection.isSuppressHeaders(), filter, this.connection.getSkipLeadingDataLines() + this.connection.getTransposedLines());
                        } else if (filter == null) {
                            in = new FileInputStream(fileName);
                        } else {
                            filter.reset();
                            in = new EncryptedFileInputStream(fileName, filter);
                        }
                        input = this.connection.getCharset() != null ? new LineNumberReader(new InputStreamReader(in, this.connection.getCharset())) : new LineNumberReader(new InputStreamReader(in));
                    } else {
                        input = new LineNumberReader(tableReader.getReader(this, tableName));
                    }
                    String charset = this.connection.getCharset();
                    if (charset != null && charset.equalsIgnoreCase("UTF-8")) {
                        input.mark(1);
                        int bom = input.read();
                        if (bom != 65279) {
                            input.reset();
                        }
                    }
                    String headerline = this.connection.getHeaderline(tableName);
                    CsvRawReader rawReader = new CsvRawReader(input, tableName, tableAlias, this.connection.getSeparator(), this.connection.isSuppressHeaders(), this.connection.isHeaderFixedWidth(), this.connection.getQuotechar(), this.connection.getCommentChar(), headerline, this.connection.getTrimHeaders(), this.connection.getTrimValues(), this.connection.getSkipLeadingLines(), this.connection.isIgnoreUnparseableLines(), this.connection.getMissingValue(), this.connection.isDefectiveHeaders(), this.connection.getSkipLeadingDataLines(), this.connection.getQuoteStyle(), this.connection.getFixedWidthColumns());
                    reader = new CsvReader(rawReader, this.connection.getTransposedLines(), this.connection.getTransposedFieldsToSkip(), headerline);
                }
            }
            catch (IOException e) {
                throw new SQLException(CsvResources.getString("fileReadError") + ": " + e);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(CsvResources.getString("dataReaderError") + ": " + e);
            }
        }
        CsvResultSet resultSet = null;
        try {
            resultSet = new CsvResultSet(this, reader, tableName, parser.getColumns(), parser.isDistinct(), this.resultSetType, parser.getWhereClause(), parser.getGroupByColumns(), parser.getHavingClause(), parser.getOrderByColumns(), parser.getLimit(), parser.getOffset(), this.connection.getColumnTypes(tableName), this.connection.getSkipLeadingLines(), parentobjectEnvironment);
            this.lastResultSet = resultSet;
        }
        catch (ClassNotFoundException e) {
            CsvDriver.writeLog("" + e);
        }
        return resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String)");
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
            this.multipleParsers = null;
            this.closed = true;
            this.connection.removeStatement(this);
        }
    }

    public boolean isCancelled() throws SQLException {
        return this.cancelled;
    }

    @Override
    public void cancel() throws SQLException {
        this.cancelled = true;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    protected void setTimeoutMillis() {
        this.timeoutMillis = this.queryTimeout == 0 || this.queryTimeout == Integer.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.queryTimeout * 1000);
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        CsvDriver.writeLog("CsvStatement:execute() - sql= " + sql);
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
            this.multipleParsers = null;
        }
        this.setTimeoutMillis();
        this.cancelled = false;
        MultipleSqlParser parser = new MultipleSqlParser();
        try {
            List<SqlParser> parsers = parser.parse(sql);
            this.lastResultSet = this.executeParsedQuery(parsers.remove(0));
            this.multipleParsers = parsers;
        }
        catch (Exception e) {
            throw new SQLException(CsvResources.getString("syntaxError") + ": " + e.getMessage(), e);
        }
        return true;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.addBatch(String)");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.clearBatch()");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.executeBatch()");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.getMoreResults(int)");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.getGeneratedKeys()");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String,int)");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String,int[])");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String,String[])");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.execute(String,int)");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.execute(String,int[])");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.execute(String,String[])");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.getResultSetHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.closeOnCompletion()");
    }
}

