/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;

public class CsvMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection connection = null;
        Properties properties = null;
        int exitStatus = 0;
        try {
            Class.forName("org.relique.jdbc.csv.CsvDriver");
            int argIndex = 0;
            if (argIndex + 1 < args.length && args[argIndex].equals("-p")) {
                properties = new Properties();
                FileReader propertiesReader = new FileReader(args[argIndex + 1]);
                try {
                    properties.load(propertiesReader);
                }
                finally {
                    ((Reader)propertiesReader).close();
                }
                argIndex += 2;
            } else if (argIndex < args.length && args[argIndex].equals("-h")) {
                argIndex = args.length;
            } else if (argIndex < args.length && args[argIndex].startsWith("-")) {
                System.err.println(CsvResources.getString("unknownCommandLine") + ": " + args[argIndex]);
                System.err.println();
                argIndex = args.length;
            }
            if (argIndex < args.length) {
                boolean isStdin;
                BufferedReader reader;
                connection = properties != null ? DriverManager.getConnection(args[argIndex], properties) : DriverManager.getConnection(args[argIndex]);
                CsvStatement statement = (CsvStatement)connection.createStatement();
                if (++argIndex == args.length) {
                    reader = new BufferedReader(new InputStreamReader(System.in));
                    isStdin = true;
                } else {
                    reader = new BufferedReader(new FileReader(args[argIndex]));
                    isStdin = false;
                    ++argIndex;
                }
                boolean writeHeaderLine = !((CsvConnection)connection).isSuppressHeaders();
                do {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    if (!isStdin) {
                        reader.close();
                    }
                    reader = null;
                    if (statement.execute(sb.toString())) {
                        ResultSet resultSet = statement.getResultSet();
                        CsvDriver.writeToCsv(resultSet, System.out, writeHeaderLine);
                        writeHeaderLine = false;
                        while (statement.getMoreResults()) {
                            resultSet = statement.getResultSet();
                            CsvDriver.writeToCsv(resultSet, System.out, writeHeaderLine);
                        }
                    }
                    if (argIndex >= args.length) continue;
                    reader = new BufferedReader(new FileReader(args[argIndex]));
                    ++argIndex;
                } while (reader != null);
            } else {
                System.err.println(CsvResources.getString("usage"));
                exitStatus = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            exitStatus = -1;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        System.exit(exitStatus);
    }
}

