/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.data;

import com.dbeaver.ee.influxdb.exec.InfluxResultSet;
import com.dbeaver.ee.influxdb.exec.InfluxResultSetMetaColumn;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementField;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementTag;
import com.dbeaver.ee.model.timeseries.TSDataProvider;
import com.dbeaver.ee.model.timeseries.TSMeasurement;
import com.dbeaver.ee.model.timeseries.TSPoint;
import com.dbeaver.ee.model.timeseries.TSProjection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.utils.CommonUtils;

public class InfluxTimeSeriesDataProvider
implements TSDataProvider {
    private static final Log log = Log.getLog(InfluxTimeSeriesDataProvider.class);
    private DBSDataContainer dataContainer;
    private QueryResult.Series series;
    private InfluxMeasurement measurement;
    private List<String> fieldNames;
    private Map<String, List<String>> tagValues;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public InfluxTimeSeriesDataProvider(DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public void initData(DBDAttributeBinding[] metaData, Object[][] data) throws DBException {
        if (metaData.length == 0) {
            return;
        }
        InfluxResultSet resultSet = ((InfluxResultSetMetaColumn)metaData[0].getMetaAttribute()).getResultSet();
        InfluxDatabase database = resultSet.getSourceStatement().getCurrentDatabase();
        this.series = resultSet.getSeries();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        List<InfluxMeasurement> measurements = database.getMeasurements((DBRProgressMonitor)monitor);
        String seriesName = this.series.getName();
        if (CommonUtils.isEmpty((String)seriesName)) {
            return;
        }
        this.measurement = (InfluxMeasurement)DBUtils.findObject(measurements, (String)seriesName);
        if (this.measurement == null) {
            throw new DBException("Measurement '" + seriesName + "' not found");
        }
        this.fieldNames = new ArrayList<String>();
        this.tagValues = new LinkedHashMap<String, List<String>>();
        for (InfluxMeasurementField field : this.measurement.getFields((DBRProgressMonitor)monitor)) {
            if ("time".equals(field.getName()) || field.getDataKind() != DBPDataKind.NUMERIC) continue;
            this.fieldNames.add(field.getName());
        }
        for (InfluxMeasurementTag tag : this.measurement.getTags((DBRProgressMonitor)monitor)) {
            List<String> values = tag.getTagValues((DBRProgressMonitor)monitor);
            this.tagValues.put(tag.getName(), values);
        }
    }

    public String getSeriesName() {
        return this.series == null ? null : this.series.getName();
    }

    @NotNull
    public List<TSMeasurement> getMeasurements() {
        ArrayList<TSMeasurement> measurements = new ArrayList<TSMeasurement>();
        if (!CommonUtils.isEmpty(this.fieldNames)) {
            for (String colName : this.series.getColumns()) {
                if (!this.fieldNames.contains(colName)) continue;
                measurements.add(new TSMeasurement(colName));
            }
        }
        return measurements;
    }

    @Nullable
    public List<TSProjection> getProjections(Object[][] data) {
        if (this.series == null) {
            return null;
        }
        ArrayList<TSProjection> projections = new ArrayList<TSProjection>();
        if (CommonUtils.isEmpty((Map)this.series.getTags())) {
            for (String tagName : this.tagValues.keySet()) {
                List<String> values = this.tagValues.get(tagName);
                if (CommonUtils.isEmpty(values)) continue;
                for (String value : values) {
                    projections.add(new TSProjection(tagName, value));
                }
            }
        } else {
            for (Map.Entry tag : this.series.getTags().entrySet()) {
                for (String tagName : this.tagValues.keySet()) {
                    List<String> values;
                    if (CommonUtils.equalObjects(tag.getKey(), (Object)tagName) || CommonUtils.isEmpty(values = this.tagValues.get(tagName))) continue;
                    for (String value : values) {
                        projections.add(new TSProjection(tagName, value));
                    }
                }
            }
        }
        return projections;
    }

    @NotNull
    public List<TSPoint> getPoints(@NotNull TSMeasurement measurement, @Nullable TSProjection projection, Object[][] rowData) throws DBException {
        ArrayList<TSPoint> points = new ArrayList<TSPoint>();
        if (this.series != null && this.series.getValues() != null) {
            int timeColumnIndex = this.series.getColumns().indexOf("time");
            int measureColumnIndex = this.series.getColumns().indexOf(measurement.getName());
            if (timeColumnIndex < 0 || measureColumnIndex < 0) {
                throw new DBException("Time and/or measure column not present in result set");
            }
            int projectIndex = projection == null ? -1 : this.series.getColumns().indexOf(projection.getName());
            Object[][] objectArray = rowData;
            int n = rowData.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    Object[] row = objectArray[n2];
                    Object timeValue = row[timeColumnIndex];
                    if (timeValue != null) {
                        if (!(timeValue instanceof Date)) {
                            try {
                                timeValue = this.formatter.parse(CommonUtils.toString((Object)timeValue));
                            }
                            catch (ParseException e) {
                                log.debug((Object)"Error parsing Influx date", (Throwable)e);
                                break block10;
                            }
                        }
                        Number measureValue = (Number)row[measureColumnIndex];
                        if (projectIndex < 0) {
                            points.add(new TSPoint((Date)timeValue, measureValue));
                        } else {
                            Object projectionValue = row[projectIndex];
                            if (CommonUtils.equalObjects((Object)projectionValue, (Object)projection.getValue())) {
                                points.add(new TSPoint((Date)timeValue, measureValue));
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return points;
    }
}

