/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.gef3.EditPart;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.command.EntityAddCommand;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class QueryTableAddCommand
extends EntityAddCommand {
    private final VQBQueryInfo queryInfo = VQBUtils.getQueryInfo((EditPart)this.getDiagram());

    public QueryTableAddCommand(DiagramPart diagram, List<ERDEntity> entities, Point location) {
        super(diagram, entities, location);
    }

    protected void handleEntityChange(ERDEntity entity, boolean remove) {
        super.handleEntityChange(entity, remove);
        VQBUtils.handleEntityChange((ERDContainer)this.getDiagram().getDiagram(), this.queryInfo, entity, remove);
    }

    public void execute() {
        DBPDataSource dataSource = this.queryInfo.getQuery().getDataSource();
        if (dataSource != null) {
            boolean isAliasAlways = VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.add.aliases.always");
            for (ERDEntity entity : this.entities) {
                List diagramEntities;
                DBPDataSource eds = entity.getDataSource();
                if (eds == null && entity.getObject() != null) {
                    eds = ((DBSEntity)entity.getObject()).getDataSource();
                }
                if (eds != null && eds != dataSource) {
                    DBWorkbench.getPlatformUI().showError("Wrong connection", "You can't add table from another database connection (" + ((DBSEntity)entity.getObject()).getDataSource().getName() + ").\n" + "Please use only tables from '" + dataSource.getName() + "'.");
                    return;
                }
                if (this.queryInfo.getQuery() == null || CommonUtils.isEmpty((Collection)(diagramEntities = this.getDiagram().getDiagram().getEntities())) || isAliasAlways || !diagramEntities.contains(entity)) continue;
                DBWorkbench.getPlatformUI().showError("Same table without alias error", "You cannot use the same table in a query without an alias");
                return;
            }
        }
        super.execute();
    }
}

