/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.graph;

import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.NodeList;

public class Edge {
    int cut;
    public Object data;
    public int delta = 1;
    public Point end;
    boolean flag;
    public boolean isFeedback = false;
    public int offsetSource = -1;
    public int offsetTarget = -1;
    public int padding = 10;
    private PointList points;
    public Node source;
    public Point start;
    public Node target;
    boolean tree;
    public NodeList vNodes;
    public int weight = 1;
    public int width = 1;

    public Edge(Node source, Node target) {
        this(null, source, target);
    }

    public Edge(Node source, Node target, int delta, int weight) {
        this(source, target);
        this.delta = delta;
        this.weight = weight;
    }

    public Edge(Object data, Node source, Node target) {
        this.data = data;
        this.source = source;
        this.target = target;
        source.outgoing.add(this);
        target.incoming.add(this);
    }

    public int getDelta() {
        return this.delta;
    }

    int getIndexForRank(int rank) {
        if (this.source.rank == rank) {
            return this.source.index;
        }
        if (this.target.rank == rank) {
            return this.target.index;
        }
        if (this.vNodes != null) {
            return this.vNodes.getNode((int)(rank - this.source.rank - 1)).index;
        }
        return -1;
    }

    public int getLength() {
        return this.target.rank - this.source.rank;
    }

    public int getPadding() {
        return this.padding;
    }

    public PointList getPoints() {
        return this.points;
    }

    int getSlack() {
        return this.target.rank - this.source.rank - this.delta;
    }

    public int getSourceOffset() {
        if (this.offsetSource != -1) {
            return this.offsetSource;
        }
        return this.source.getOffsetOutgoing();
    }

    public int getTargetOffset() {
        if (this.offsetTarget != -1) {
            return this.offsetTarget;
        }
        return this.target.getOffsetIncoming();
    }

    public int getWidth() {
        return this.width;
    }

    public void invert() {
        this.source.outgoing.remove(this);
        this.target.incoming.remove(this);
        Node oldTarget = this.target;
        this.target = this.source;
        this.source = oldTarget;
        int temp = this.offsetSource;
        this.offsetSource = this.offsetTarget;
        this.offsetTarget = temp;
        this.target.incoming.add(this);
        this.source.outgoing.add(this);
        if (this.points != null) {
            this.points.reverse();
        }
        if (this.vNodes != null) {
            NodeList newVNodes = new NodeList();
            int j = this.vNodes.size() - 1;
            while (j >= 0) {
                newVNodes.add(this.vNodes.getNode(j));
                --j;
            }
            this.vNodes = newVNodes;
        }
        if (this.start != null) {
            Point pt = this.start;
            this.start = this.end;
            this.end = pt;
        }
    }

    public boolean isFeedback() {
        return this.isFeedback;
    }

    public Node opposite(Node end) {
        if (this.source == end) {
            return this.target;
        }
        return this.source;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    void setPoints(PointList points) {
        this.points = points;
        this.start = points.getFirstPoint();
        this.end = points.getLastPoint();
    }

    public void setSource(Node node) {
        if (this.source == node) {
            return;
        }
        if (this.source != null) {
            this.source.outgoing.remove(this);
        }
        this.source = node;
        if (this.source != null) {
            this.source.outgoing.add(this);
        }
    }

    public void setSourceOffset(int offset) {
        this.offsetSource = offset;
    }

    public void setTarget(Node node) {
        if (this.target == node) {
            return;
        }
        if (this.target != null) {
            this.target.incoming.remove(this);
        }
        this.target = node;
        if (this.target != null) {
            this.target.incoming.add(this);
        }
    }

    public void setTargetOffset(int offset) {
        this.offsetTarget = offset;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

