/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2dl.Clickable;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.RangeModel;
import org.eclipse.draw2dl.ScrollBar;
import org.eclipse.draw2dl.ScrollPane;
import org.eclipse.draw2dl.ScrollPaneLayout;
import org.eclipse.draw2dl.Viewport;

public class PuristicScrollPane
extends ScrollPane {
    public PuristicScrollPane() {
        this.setLayoutManager(new ScrollPaneLayout(){

            @Override
            public void layout(IFigure parent) {
                super.layout(parent);
                ScrollPane scrollpane = (ScrollPane)parent;
                Viewport viewport = scrollpane.getViewport();
                viewport.setBounds(parent.getClientArea());
            }
        });
    }

    @Override
    protected void createVerticalScrollBar() {
        PuristicScrollBar verticalScrollBar = new PuristicScrollBar(false);
        this.setVerticalScrollBar(verticalScrollBar);
    }

    @Override
    protected void createHorizontalScrollBar() {
        PuristicScrollBar horizontalScrollBar = new PuristicScrollBar(true);
        this.setHorizontalScrollBar(horizontalScrollBar);
    }

    public class PuristicScrollBar
    extends ScrollBar {
        public PuristicScrollBar(boolean isHorizontal) {
            this.setHorizontal(isHorizontal);
            this.setOpaque(false);
        }

        @Override
        protected Clickable createDefaultDownButton() {
            Clickable buttonDown = super.createDefaultDownButton();
            buttonDown.setBorder(null);
            buttonDown.setOpaque(false);
            return buttonDown;
        }

        @Override
        protected IFigure createDefaultThumb() {
            return null;
        }

        @Override
        protected Clickable createDefaultUpButton() {
            Clickable buttonUp = super.createDefaultUpButton();
            buttonUp.setBorder(null);
            buttonUp.setOpaque(false);
            return buttonUp;
        }

        @Override
        protected Clickable createPageDown() {
            return null;
        }

        @Override
        protected Clickable createPageUp() {
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() instanceof RangeModel) {
                this.getButtonDown().setVisible(this.getValue() != this.getMaximum() - this.getExtent());
                this.getButtonUp().setVisible(this.getValue() != this.getMinimum());
            }
            super.propertyChange(event);
        }
    }
}

