/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.draw2dl.ChangeEvent;
import org.eclipse.draw2dl.ChangeListener;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.Toggle;
import org.eclipse.swt.graphics.Image;

public final class CheckBox
extends Toggle {
    private Label label = null;
    static final Image UNCHECKED = CheckBox.createImage("images/checkboxenabledoff.gif");
    static final Image CHECKED = CheckBox.createImage("images/checkboxenabledon.gif");

    private static Image createImage(String name) {
        InputStream stream = CheckBox.class.getResourceAsStream(name);
        Image image = new Image(null, stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    public CheckBox() {
        this("");
    }

    public CheckBox(String text) {
        this.label = new Label(text, UNCHECKED);
        this.setContents(this.label);
    }

    protected void handleSelectionChanged() {
        if (this.isSelected()) {
            this.label.setIcon(CHECKED);
        } else {
            this.label.setIcon(UNCHECKED);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void handleStateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getPropertyName().equals("selected")) {
                    CheckBox.this.handleSelectionChanged();
                }
            }
        });
    }
}

