/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.sql.plan.diagram.features;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ICreateService;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class PlanCreateConnectionFeature
extends AbstractCreateConnectionFeature {
    private static boolean cancel = false;

    public PlanCreateConnectionFeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description);
    }

    public static void setCancelling(boolean cancel) {
        PlanCreateConnectionFeature.cancel = cancel;
    }

    public static boolean isCancelling() {
        return cancel;
    }

    protected Connection createConnection() {
        if (PlanCreateConnectionFeature.isCancelling()) {
            throw new OperationCanceledException();
        }
        FreeFormConnection f = Graphiti.getPeCreateService().createFreeFormConnection(this.getDiagram());
        return f;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        AnchorContainer sourceParent;
        boolean ret = false;
        Anchor sourceAnchor = context.getSourceAnchor();
        Anchor targetAnchor = context.getTargetAnchor();
        if (sourceAnchor != null && targetAnchor != null && (sourceParent = sourceAnchor.getParent()) != null && !sourceParent.equals(targetAnchor.getParent())) {
            ret = true;
        }
        PictogramElement sourcePe = context.getSourcePictogramElement();
        PictogramElement targetPe = context.getTargetPictogramElement();
        if (sourcePe != null && sourcePe.equals(targetPe)) {
            return false;
        }
        if (sourcePe instanceof Connection || targetPe instanceof Connection) {
            return true;
        }
        return ret;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        boolean ret = false;
        if (context.getSourceAnchor() != null || context.getSourcePictogramElement() instanceof Connection) {
            ret = true;
        }
        return ret;
    }

    public static Shape createConnectionPoint(ILocation location, ContainerShape cs) {
        ICreateService createService = Graphiti.getCreateService();
        IPeService peService = Graphiti.getPeService();
        Shape ret = createService.createShape(cs, true);
        Ellipse ellipse = createService.createEllipse((GraphicsAlgorithmContainer)ret);
        int x = 0;
        int y = 0;
        if (location != null) {
            x = location.getX();
            y = location.getY();
        }
        Graphiti.getLayoutService().setLocationAndSize((GraphicsAlgorithm)ellipse, x - 8, y - 8, 16, 16);
        ellipse.setFilled(Boolean.valueOf(true));
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)ret);
        ellipse.setForeground(Graphiti.getGaService().manageColor(diagram, IColorConstant.LIGHT_BLUE));
        return ret;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection splitConnection;
        Shape s;
        ICreateService cs = Graphiti.getCreateService();
        Anchor startAnchor = context.getSourceAnchor();
        Anchor endAnchor = context.getTargetAnchor();
        if (startAnchor == null && context.getSourcePictogramElement() instanceof Connection) {
            s = PlanCreateConnectionFeature.createConnectionPoint(context.getSourceLocation(), (ContainerShape)this.getDiagram());
            startAnchor = cs.createChopboxAnchor((AnchorContainer)s);
            splitConnection = (Connection)context.getSourcePictogramElement();
            this.createConnection(splitConnection.getStart(), startAnchor);
            this.createConnection(startAnchor, splitConnection.getEnd());
            EcoreUtil.delete((EObject)splitConnection);
        }
        if (endAnchor == null && context.getTargetPictogramElement() instanceof Connection) {
            s = PlanCreateConnectionFeature.createConnectionPoint(context.getTargetLocation(), (ContainerShape)this.getDiagram());
            endAnchor = cs.createChopboxAnchor((AnchorContainer)s);
            splitConnection = (Connection)context.getTargetPictogramElement();
            this.createConnection(splitConnection.getStart(), endAnchor);
            this.createConnection(endAnchor, splitConnection.getEnd());
            EcoreUtil.delete((EObject)splitConnection);
        }
        if (startAnchor == null || endAnchor == null) {
            return null;
        }
        Connection connection = this.createConnection(startAnchor, endAnchor);
        context.getSourcePictogramElement();
        context.getTargetPictogramElement();
        if (!startAnchor.isVisible() || !endAnchor.isVisible()) {
            connection.setVisible(false);
            connection.setVisible(false);
        }
        return connection;
    }

    protected Connection createConnection(Anchor startAnchor, Anchor endAnchor) {
        Connection connection = this.createConnection();
        this.createVisualization(connection);
        this.setAnchors(startAnchor, endAnchor, connection);
        return connection;
    }

    protected void setAnchors(Anchor startAnchor, Anchor endAnchor, Connection connection) {
        connection.setStart(startAnchor);
        connection.setEnd(endAnchor);
    }

    protected void createVisualization(Connection connection) {
        Polyline p = Graphiti.getCreateService().createPolyline((GraphicsAlgorithmContainer)connection);
        p.setForeground(this.manageColor(IColorConstant.BLACK));
        p.setLineStyle(LineStyle.SOLID);
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        ConnectionDecorator endDecorator = peService.createConnectionDecorator(connection, false, 1.0, true);
        ConnectionDecorator startDecorator = peService.createConnectionDecorator(connection, false, 0.0, true);
        int w = 6;
        int l = 10;
        int[] nArray = new int[8];
        nArray[0] = -l;
        nArray[1] = w;
        nArray[4] = -l;
        nArray[5] = -w;
        nArray[6] = -l;
        nArray[7] = w;
        Polygon arrowhead = gaService.createPolygon((GraphicsAlgorithmContainer)endDecorator, nArray);
        arrowhead.setBackground(this.manageColor(IColorConstant.BLACK));
        arrowhead.setForeground(this.manageColor(IColorConstant.BLACK));
        Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)startDecorator);
        gaService.setSize((GraphicsAlgorithm)circle, 5, 5);
        circle.setBackground(this.manageColor(IColorConstant.WHITE));
    }
}

