/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.SnapShot;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTxnSnapLog {
    private final File dataDir;
    private final File snapDir;
    private TxnLog txnLog;
    private SnapShot snapLog;
    public static final int VERSION = 2;
    public static final String version = "version-";
    private static final Logger LOG = LoggerFactory.getLogger(FileTxnSnapLog.class);

    public FileTxnSnapLog(File dataDir, File snapDir) throws IOException {
        LOG.debug("Opening datadir:{} snapDir:{}", (Object)dataDir, (Object)snapDir);
        this.dataDir = new File(dataDir, "version-2");
        this.snapDir = new File(snapDir, "version-2");
        if (!(this.dataDir.exists() || this.dataDir.mkdirs() || this.dataDir.exists())) {
            throw new IOException("Unable to create data directory " + this.dataDir);
        }
        if (!(this.snapDir.exists() || this.snapDir.exists() || this.snapDir.mkdirs())) {
            throw new IOException("Unable to create snap directory " + this.snapDir);
        }
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getSnapDir() {
        return this.snapDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long restore(DataTree dt, Map<Long, Integer> sessions, PlayBackListener listener) throws IOException {
        long highestZxid;
        TxnLog.TxnIterator itr;
        block9: {
            long l;
            block8: {
                this.snapLog.deserialize(dt, sessions);
                FileTxnLog txnLog = new FileTxnLog(this.dataDir);
                itr = txnLog.read(dt.lastProcessedZxid + 1L);
                highestZxid = dt.lastProcessedZxid;
                try {
                    do {
                        TxnHeader hdr;
                        if ((hdr = itr.getHeader()) == null) {
                            l = dt.lastProcessedZxid;
                            Object var12_10 = null;
                            if (itr == null) return l;
                            break block8;
                        }
                        if (hdr.getZxid() < highestZxid && highestZxid != 0L) {
                            LOG.error("{}(higestZxid) > {}(next log) for type {}", highestZxid, hdr.getZxid(), hdr.getType());
                        } else {
                            highestZxid = hdr.getZxid();
                        }
                        try {
                            this.processTransaction(hdr, dt, sessions, itr.getTxn());
                        }
                        catch (KeeperException.NoNodeException e) {
                            throw new IOException("Failed to process transaction type: " + hdr.getType() + " error: " + e.getMessage(), e);
                        }
                        listener.onTxnLoaded(hdr, itr.getTxn());
                    } while (itr.next());
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (itr == null) throw throwable;
                    itr.close();
                    throw throwable;
                }
            }
            itr.close();
            return l;
        }
        Object var12_11 = null;
        if (itr == null) return highestZxid;
        itr.close();
        return highestZxid;
    }

    public void processTransaction(TxnHeader hdr, DataTree dt, Map<Long, Integer> sessions, Record txn) throws KeeperException.NoNodeException {
        DataTree.ProcessTxnResult rc;
        switch (hdr.getType()) {
            case -10: {
                sessions.put(hdr.getClientId(), ((CreateSessionTxn)txn).getTimeOut());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- create session in log: 0x" + Long.toHexString(hdr.getClientId()) + " with timeout: " + ((CreateSessionTxn)txn).getTimeOut());
                }
                rc = dt.processTxn(hdr, txn);
                break;
            }
            case -11: {
                sessions.remove(hdr.getClientId());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- close session in log: 0x" + Long.toHexString(hdr.getClientId()));
                }
                rc = dt.processTxn(hdr, txn);
                break;
            }
            default: {
                rc = dt.processTxn(hdr, txn);
            }
        }
        if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr:" + hdr.getType() + ", error: " + rc.err + ", path: " + rc.path);
        }
    }

    public long getLastLoggedZxid() {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        return txnLog.getLastLoggedZxid();
    }

    public void save(DataTree dataTree, ConcurrentHashMap<Long, Integer> sessionsWithTimeouts) throws IOException {
        long lastZxid = dataTree.lastProcessedZxid;
        File snapshotFile = new File(this.snapDir, Util.makeSnapshotName(lastZxid));
        LOG.info("Snapshotting: 0x{} to {}", (Object)Long.toHexString(lastZxid), (Object)snapshotFile);
        this.snapLog.serialize(dataTree, sessionsWithTimeouts, snapshotFile);
    }

    public boolean truncateLog(long zxid) throws IOException {
        this.close();
        FileTxnLog truncLog = new FileTxnLog(this.dataDir);
        boolean truncated = truncLog.truncate(zxid);
        truncLog.close();
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
        return truncated;
    }

    public File findMostRecentSnapshot() throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findMostRecentSnapshot();
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findNRecentSnapshots(n);
    }

    public File[] getSnapshotLogs(long zxid) {
        return FileTxnLog.getLogFiles(this.dataDir.listFiles(), zxid);
    }

    public boolean append(Request si) throws IOException {
        return this.txnLog.append(si.hdr, si.txn);
    }

    public void commit() throws IOException {
        this.txnLog.commit();
    }

    public void rollLog() throws IOException {
        this.txnLog.rollLog();
    }

    public void close() throws IOException {
        this.txnLog.close();
        this.snapLog.close();
    }

    public static interface PlayBackListener {
        public void onTxnLoaded(TxnHeader var1, Record var2);
    }
}

